/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.block;

import calemiutils.CalemiUtils;
import calemiutils.block.base.BlockBase;
import calemiutils.config.CUConfig;
import calemiutils.init.InitBlocks;
import calemiutils.util.Location;
import calemiutils.util.MaterialSound;
import calemiutils.util.VeinScan;
import calemiutils.util.helper.BlockHelper;
import calemiutils.util.helper.EntityHelper;
import calemiutils.util.helper.ItemHelper;
import calemiutils.util.helper.LoreHelper;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockScaffold
extends BlockBase {
    public BlockScaffold() {
        super("iron_scaffold", MaterialSound.IRON, 0.1f, 0, 2.0f);
        this.func_149647_a(CalemiUtils.TAB);
        if (CUConfig.blockUtils.ironScaffold) {
            this.addBlock();
        }
    }

    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        LoreHelper.addInformationLore(tooltip, "Temporary block used for getting to the hard to reach places!");
        LoreHelper.addControlsLore(tooltip, "Teleport to the top", LoreHelper.Type.USE_OPEN_HAND, true);
        LoreHelper.addControlsLore(tooltip, "Break all connected scaffolds", LoreHelper.Type.SNEAK_BREAK_BLOCK);
        LoreHelper.addControlsLore(tooltip, "Place Scaffold in a line", LoreHelper.Type.LEFT_CLICK_BLOCK);
        LoreHelper.addControlsLore(tooltip, "Place Scaffold upwards", LoreHelper.Type.SNEAK_LEFT_CLICK_BLOCK);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        block7: {
            ItemStack stack = player.func_184614_ca();
            if (!stack.func_190926_b()) break block7;
            Location location = new Location(world, pos);
            if (CUConfig.misc.scaffoldMaxHeightTp == 0) {
                return false;
            }
            if (facing != EnumFacing.UP) {
                for (int i = 0; i < CUConfig.misc.scaffoldMaxHeightTp; ++i) {
                    Location nextLocation = new Location(location, EnumFacing.UP, i);
                    Location nextLocationUp = new Location(location, EnumFacing.UP, i + 1);
                    if (!nextLocation.isAirBlock() && !(nextLocation.getBlock() instanceof BlockScaffold)) {
                        return false;
                    }
                    if (!nextLocation.isAirBlock() || !nextLocationUp.isAirBlock() || world.field_72995_K || !EntityHelper.canTeleportAt((EntityPlayerMP)player, nextLocation)) continue;
                    EntityHelper.teleportPlayer((EntityPlayerMP)player, nextLocation, ((EntityPlayerMP)player).field_71093_bK);
                    return true;
                }
            } else {
                for (int i = 0; i < CUConfig.misc.scaffoldMaxHeightTp; ++i) {
                    Location nextLocation = new Location(location, EnumFacing.DOWN, i);
                    Location nextLocationDown = new Location(location, EnumFacing.DOWN, i + 1);
                    if (nextLocationDown.getBlock() instanceof BlockScaffold) continue;
                    for (EnumFacing dir : EnumFacing.field_82609_l) {
                        if (world.field_72995_K || !EntityHelper.canTeleportAt((EntityPlayerMP)player, new Location(nextLocation, dir))) continue;
                        EntityHelper.teleportPlayer((EntityPlayerMP)player, new Location(nextLocation, dir), ((EntityPlayerMP)player).field_71093_bK);
                        return true;
                    }
                    break;
                }
            }
        }
        return false;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        int face = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        EnumFacing dir = null;
        if (face == 0) {
            dir = EnumFacing.SOUTH;
        }
        if (face == 1) {
            dir = EnumFacing.WEST;
        }
        if (face == 2) {
            dir = EnumFacing.NORTH;
        }
        if (face == 3) {
            dir = EnumFacing.EAST;
        }
        if (!player.func_70093_af()) {
            BlockHelper.placeBlockInArray(world, pos, player, this, dir);
        } else {
            BlockHelper.placeBlockInArray(world, pos, player, this, EnumFacing.UP);
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        Location location = new Location(world, pos);
        if (player.func_70093_af()) {
            VeinScan scan = new VeinScan(location, this);
            scan.startScan();
            for (Location nextLocation : scan.buffer) {
                nextLocation.setBlockToAir();
                if (player.field_71075_bZ.field_75098_d || world.field_72995_K) continue;
                ItemHelper.spawnItem(world, new Location((Entity)player), new ItemStack(InitBlocks.IRON_SCAFFOLD));
            }
        } else {
            if (!world.field_72995_K) {
                ItemHelper.spawnItem(world, new Location((Entity)player), new ItemStack(InitBlocks.IRON_SCAFFOLD));
            }
            location.setBlockToAir();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }
}

