/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.block;

import calemiutils.CalemiUtils;
import calemiutils.block.base.BlockInventoryContainerBase;
import calemiutils.config.CUConfig;
import calemiutils.init.InitItems;
import calemiutils.item.ItemWallet;
import calemiutils.tileentity.TileEntityTradingPost;
import calemiutils.util.HardnessConstants;
import calemiutils.util.IExtraInformation;
import calemiutils.util.Location;
import calemiutils.util.MaterialSound;
import calemiutils.util.UnitChatMessage;
import calemiutils.util.helper.CurrencyHelper;
import calemiutils.util.helper.InventoryHelper;
import calemiutils.util.helper.ItemHelper;
import calemiutils.util.helper.LoreHelper;
import calemiutils.util.helper.SecurityHelper;
import calemiutils.util.helper.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTradingPost
extends BlockInventoryContainerBase
implements IExtraInformation {
    private static final float pixel = 0.0625f;
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);

    public BlockTradingPost() {
        super("trading_post", MaterialSound.IRON, HardnessConstants.SECURED);
        this.func_149647_a(CalemiUtils.TAB);
        if (CUConfig.blockUtils.tradingPost && CUConfig.economy.economy) {
            this.addBlock();
        }
    }

    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        LoreHelper.addInformationLore(tooltip, "Used to buy and sell blocks and items.");
        LoreHelper.addControlsLore(tooltip, "Show Trade Info", LoreHelper.Type.SNEAK_USE, true);
        LoreHelper.addControlsLore(tooltip, "Open Inventory", LoreHelper.Type.USE_WRENCH);
        LoreHelper.addControlsLore(tooltip, "Buy Item", LoreHelper.Type.USE_WALLET);
    }

    @Override
    public void getButtonInformation(List<String> list, World world, Location location, ItemStack stack) {
        TileEntity te = location.getTileEntity();
        if (te instanceof TileEntityTradingPost) {
            TileEntityTradingPost post = (TileEntityTradingPost)te;
            if (post.hasValidTradeOffer) {
                list.add("Trading: " + post.getStackForSale().func_82833_r());
                list.add("Amount: " + StringHelper.printCommas(post.amountForSale));
                list.add("Price: " + StringHelper.printCurrency(post.salePrice));
            }
        }
    }

    @Override
    public ItemStack getButtonIcon(World world, Location location, ItemStack stack) {
        TileEntity te = location.getTileEntity();
        if (te instanceof TileEntityTradingPost) {
            TileEntityTradingPost post = (TileEntityTradingPost)te;
            if (post.hasValidTradeOffer) {
                return post.getStackForSale();
            }
        }
        return stack;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (placer instanceof EntityPlayer) {
            Location location;
            TileEntity te;
            EntityPlayer player = (EntityPlayer)placer;
            if (player.field_71075_bZ.field_75098_d && !player.func_70093_af() && (te = (location = new Location(worldIn, pos)).getTileEntity()) instanceof TileEntityTradingPost) {
                TileEntityTradingPost tePost = (TileEntityTradingPost)te;
                tePost.adminMode = true;
                if (!worldIn.field_72995_K) {
                    tePost.getUnitName(player).printMessage(TextFormatting.GREEN, "Admin Mode is enabled for this block. Sneak place this block to disable it.");
                }
            }
        }
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Location location = new Location(world, pos);
        ItemStack heldStack = player.func_184586_b(hand);
        ItemStack walletStack = CurrencyHelper.getCurrentWalletStack(player);
        TileEntity te = location.getTileEntity();
        if (te instanceof TileEntityTradingPost) {
            TileEntityTradingPost tePost = (TileEntityTradingPost)te;
            UnitChatMessage message = tePost.getUnitName(player);
            if (!player.func_70093_af() && heldStack.func_77973_b() == InitItems.SECURITY_WRENCH) {
                if (SecurityHelper.openSecuredBlock(location, player, true)) {
                    FMLNetworkHandler.openGui((EntityPlayer)player, (Object)CalemiUtils.instance, (int)0, (World)world, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
                }
            } else if (!player.func_70093_af() && !walletStack.func_190926_b()) {
                this.handleTrade(message, world, player, tePost);
            } else if (!world.field_72995_K) {
                if (tePost.hasValidTradeOffer) {
                    if (tePost.adminMode) {
                        message.printMessage(TextFormatting.GREEN, (tePost.buyMode ? "Buying " : "Selling ") + StringHelper.printCommas(tePost.amountForSale) + " " + tePost.getStackForSale().func_82833_r() + " for " + (tePost.salePrice > 0 ? StringHelper.printCurrency(tePost.salePrice) : "free"));
                    } else {
                        message.printMessage(TextFormatting.GREEN, tePost.getSecurityProfile().getOwnerName() + " is " + (tePost.buyMode ? "buying " : "selling ") + StringHelper.printCommas(tePost.amountForSale) + " " + tePost.getStackForSale().func_82833_r() + " for " + (tePost.salePrice > 0 ? StringHelper.printCurrency(tePost.salePrice) : "free"));
                    }
                    message.printMessage(TextFormatting.GREEN, "Hold a wallet in your inventory to make a purchase.");
                } else {
                    message.printMessage(TextFormatting.RED, "There is nothing to trade!");
                }
            }
        }
        return true;
    }

    private void handleTrade(UnitChatMessage message, World world, EntityPlayer player, TileEntityTradingPost tePost) {
        ItemStack walletStack = CurrencyHelper.getCurrentWalletStack(player);
        ItemWallet wallet = (ItemWallet)walletStack.func_77973_b();
        if (tePost.getBank() != null || tePost.salePrice <= 0 || tePost.adminMode) {
            if (tePost.hasValidTradeOffer) {
                if (tePost.buyMode) {
                    this.handleSell(message, walletStack, world, player, tePost);
                } else {
                    this.handlePurchase(message, walletStack, world, player, tePost);
                }
            } else if (!world.field_72995_K) {
                message.printMessage(TextFormatting.RED, "The trade is not set up properly!");
            }
        } else if (!world.field_72995_K) {
            message.printMessage(TextFormatting.RED, "There is no active connected Bank!");
        }
    }

    private void handlePurchase(UnitChatMessage message, ItemStack walletStack, World world, EntityPlayer player, TileEntityTradingPost tePost) {
        if (tePost.getStock() >= tePost.amountForSale || tePost.adminMode) {
            if (ItemWallet.getBalance(walletStack) >= tePost.salePrice) {
                NBTTagCompound nbt = ItemHelper.getNBT(walletStack);
                if (tePost.getStoredCurrencyInBank() + tePost.salePrice < CUConfig.misc.postCurrencyCapacity) {
                    ItemStack is = new ItemStack(tePost.getStackForSale().func_77973_b(), tePost.amountForSale, tePost.getStackForSale().func_77952_i());
                    if (tePost.getStackForSale().func_77942_o()) {
                        is.func_77982_d(tePost.getStackForSale().func_77978_p());
                    }
                    if (tePost.adminMode) {
                        if (!world.field_72995_K) {
                            EntityItem dropItem = ItemHelper.spawnItem(world, (Entity)player, is);
                            if (is.func_77942_o()) {
                                dropItem.func_92059_d().func_77982_d(is.func_77978_p());
                            }
                            tePost.addStoredCurrencyInBank(tePost.salePrice);
                            tePost.markForUpdate();
                            nbt.func_74768_a("balance", nbt.func_74762_e("balance") - tePost.salePrice);
                        }
                    } else {
                        int count = InventoryHelper.countItems((IInventory)tePost, false, true, tePost.getStackForSale());
                        if (count >= tePost.amountForSale) {
                            if (!world.field_72995_K) {
                                EntityItem dropItem = ItemHelper.spawnItem(world, (Entity)player, is);
                                if (tePost.getStackForSale().func_77942_o()) {
                                    dropItem.func_92059_d().func_77982_d(tePost.getStackForSale().func_77978_p());
                                }
                            }
                            InventoryHelper.consumeItem(0, (IInventory)tePost, tePost.amountForSale, true, true, tePost.getStackForSale());
                            tePost.addStoredCurrencyInBank(tePost.salePrice);
                            tePost.markForUpdate();
                            tePost.func_189515_b(tePost.getTileData());
                            nbt.func_74768_a("balance", nbt.func_74762_e("balance") - tePost.salePrice);
                        }
                    }
                } else if (!world.field_72995_K) {
                    message.printMessage(TextFormatting.RED, "Full of money!");
                }
            } else if (!world.field_72995_K) {
                message.printMessage(TextFormatting.RED, "You don't have enough money!");
            }
        } else if (!world.field_72995_K) {
            message.printMessage(TextFormatting.RED, "There is not enough items in stock!");
        }
    }

    private void handleSell(UnitChatMessage message, ItemStack walletStack, World world, EntityPlayer player, TileEntityTradingPost tePost) {
        if (InventoryHelper.countItems((IInventory)player.field_71071_by, true, true, tePost.getStackForSale()) >= tePost.amountForSale) {
            ItemStack is = new ItemStack(tePost.getStackForSale().func_77973_b(), tePost.amountForSale, tePost.getStackForSale().func_77952_i());
            if (InventoryHelper.canInsertItem(is, (IInventory)tePost) || tePost.adminMode) {
                if (CurrencyHelper.canFitAddedCurrencyToWallet(walletStack, tePost.salePrice)) {
                    if (tePost.getStoredCurrencyInBank() >= tePost.salePrice || tePost.getStoredCurrencyInBank() >= tePost.salePrice || tePost.adminMode) {
                        NBTTagCompound nbt = ItemHelper.getNBT(walletStack);
                        InventoryHelper.consumeItem((IInventory)player.field_71071_by, tePost.amountForSale, true, tePost.getStackForSale());
                        if (!tePost.adminMode) {
                            InventoryHelper.insertItem(is, (IInventory)tePost);
                            if (tePost.getStoredCurrencyInBank() >= tePost.salePrice) {
                                tePost.addStoredCurrencyInBank(-tePost.salePrice);
                            } else {
                                tePost.decrStoredCurrencyInBank(tePost.salePrice);
                            }
                        }
                        nbt.func_74768_a("balance", ItemWallet.getBalance(walletStack) + tePost.salePrice);
                    } else if (!world.field_72995_K) {
                        message.printMessage(TextFormatting.RED, "The Trading Post is out of money");
                    }
                } else if (!world.field_72995_K) {
                    message.printMessage(TextFormatting.RED, "Your Wallet is full of money!");
                }
            } else if (!world.field_72995_K) {
                message.printMessage(TextFormatting.RED, "The Trading Post's stock is full!");
            }
        } else if (!world.field_72995_K) {
            message.printMessage(TextFormatting.RED, "You do not have the required item(s) the Trading Post is looking for!");
        }
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        BlockTradingPost.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityTradingPost();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }
}

