/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.blueprint;

import calemiutils.block.BlockBlueprint;
import calemiutils.blueprint.BlueprintPos;
import calemiutils.init.InitBlocks;
import calemiutils.tileentity.TileEntityBuildingUnit;
import calemiutils.util.Location;
import calemiutils.util.helper.ItemHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class BlueprintTemplate {
    public final ArrayList<BlueprintPos> positions;

    public BlueprintTemplate(ArrayList<BlueprintPos> positions) {
        this.positions = positions;
    }

    public static BlueprintTemplate scan(TileEntityBuildingUnit te) {
        Location location = te.getLocation();
        int horRad = te.horRange;
        int verRad = te.verRange;
        ArrayList<BlueprintPos> list = new ArrayList<BlueprintPos>();
        for (int x = -horRad; x < horRad; ++x) {
            for (int y = 0; y < verRad; ++y) {
                for (int z = -horRad; z < horRad; ++z) {
                    Location nextLocation = new Location(location.world, location.x + x, location.y + y, location.z + z);
                    if (!(nextLocation.getBlock() instanceof BlockBlueprint)) continue;
                    BlueprintPos pos = new BlueprintPos(x, y, z, nextLocation.getBlockMeta());
                    list.add(pos);
                }
            }
        }
        return new BlueprintTemplate(list);
    }

    public static BlueprintTemplate readFromItem(ItemStack stack) {
        NBTTagCompound nbt = ItemHelper.getNBT(stack);
        ArrayList<BlueprintPos> positions = new ArrayList<BlueprintPos>();
        if (nbt.func_74764_b("Template")) {
            NBTTagCompound template = nbt.func_74775_l("Template");
            for (int i = 0; i < template.func_186856_d(); ++i) {
                NBTTagCompound posNbt = template.func_74775_l("P-" + i);
                positions.add(new BlueprintPos(posNbt.func_74762_e("X"), posNbt.func_74762_e("Y"), posNbt.func_74762_e("Z"), posNbt.func_74762_e("M")));
            }
        }
        return new BlueprintTemplate(positions);
    }

    public BlueprintTemplate add(int meta, Location origin, Location ... locations) {
        for (Location location : locations) {
            this.positions.add(BlueprintPos.fromLocation(origin, location, meta));
        }
        return this;
    }

    public List<BlueprintPos> getPositions(int rotation) {
        ArrayList<BlueprintPos> rotatedPositions = new ArrayList<BlueprintPos>();
        for (BlueprintPos pos : this.positions) {
            int rotX = pos.x;
            int rotZ = pos.z;
            if (rotation == 1) {
                rotX = -rotX;
            } else if (rotation == 2) {
                rotX = -rotX;
                rotZ = -rotZ;
            } else if (rotation == 3) {
                rotZ = -rotZ;
            }
            rotatedPositions.add(new BlueprintPos(rotX, pos.y, rotZ, pos.meta));
        }
        return rotatedPositions;
    }

    public void construct(TileEntityBuildingUnit te) {
        for (BlueprintPos pos : this.getPositions(te.currentRotation)) {
            Location location = pos.toLocation(te);
            if (!location.isBlockValidForPlacing(InitBlocks.BLUEPRINT)) continue;
            location.setBlock(InitBlocks.BLUEPRINT.func_176203_a(pos.meta));
        }
    }

    public ItemStack writeToItem(ItemStack stack) {
        NBTTagCompound posNbt = new NBTTagCompound();
        for (int i = 0; i < this.positions.size(); ++i) {
            NBTTagCompound nbt = new NBTTagCompound();
            BlueprintPos pos = this.positions.get(i);
            nbt.func_74768_a("X", pos.x);
            nbt.func_74768_a("Y", pos.y);
            nbt.func_74768_a("Z", pos.z);
            nbt.func_74768_a("M", pos.meta);
            posNbt.func_74782_a("P-" + i, (NBTBase)nbt);
        }
        ItemHelper.getNBT(stack).func_74782_a("Template", (NBTBase)posNbt);
        return stack;
    }
}

