/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.command;

import calemiutils.block.BlockBlueprint;
import calemiutils.config.CUConfig;
import calemiutils.config.MarketItemsFile;
import calemiutils.config.MiningUnitCostsFile;
import calemiutils.init.InitBlocks;
import calemiutils.item.ItemBrush;
import calemiutils.tileentity.TileEntityMarket;
import calemiutils.util.Location;
import calemiutils.util.helper.ChatHelper;
import calemiutils.util.helper.WorldEditHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class CUCommandBase
extends CommandBase {
    private final String[] worldEditOptions = new String[]{"cube", "circle", "move"};

    public String func_71517_b() {
        return "cu";
    }

    public String func_71518_a(ICommandSender sender) {
        return "nothing";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] strings, @Nullable BlockPos targetPos) {
        if (strings.length == 1) {
            return CUCommandBase.func_71530_a((String[])strings, (String[])this.worldEditOptions);
        }
        if (strings.length == 2) {
            String[] names = new String[EnumDyeColor.values().length];
            for (int i = 0; i < EnumDyeColor.values().length; ++i) {
                names[i] = EnumDyeColor.func_176764_b((int)i).func_176610_l();
            }
            return CUCommandBase.func_71530_a((String[])strings, (String[])names);
        }
        return CUCommandBase.func_175762_a((String[])strings, (Collection)Block.field_149771_c.func_148742_b());
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] strings) throws NumberInvalidException {
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            ItemStack stack = player.func_184614_ca();
            if (strings.length == 0) {
                String holdBrush = "[Hold Brush]";
                ChatHelper.printModMessage(TextFormatting.GREEN, "----- Help for Calemi's Utils -----", player);
                ChatHelper.printModMessage(TextFormatting.GREEN, "() are optional arguments.", player);
                ChatHelper.printModMessage(TextFormatting.GREEN, " /cu reload - Reloads the MarketItems and MiningUnitCosts files.", player);
                ChatHelper.printModMessage(TextFormatting.GREEN, holdBrush + " /cu cube <color> (block) - Creates a cube of blueprint. <color> Color. (block) the block it replaces.", player);
                ChatHelper.printModMessage(TextFormatting.GREEN, holdBrush + " /cu circle <color> (block) - Creates a circle of blueprint. <color> Color. (block) the block it replaces.", player);
                ChatHelper.printModMessage(TextFormatting.GREEN, holdBrush + " /cu move - Moves the cube selection (Not implemented)", player);
            } else if (strings[0].equals("reload")) {
                MiningUnitCostsFile.init();
                MarketItemsFile.init();
                for (TileEntity te : player.field_70170_p.field_147482_g) {
                    if (!(te instanceof TileEntityMarket)) continue;
                    ((TileEntityMarket)te).dirtyFlag = true;
                }
                ChatHelper.printModMessage(TextFormatting.GREEN, "Successfully reloaded the files!", player);
            } else if (stack.func_77973_b() instanceof ItemBrush) {
                Block mask;
                ItemBrush brush = (ItemBrush)stack.func_77973_b();
                BlockBlueprint block = (BlockBlueprint)InitBlocks.BLUEPRINT;
                IBlockState state = block.func_176223_P();
                if (strings.length > 1) {
                    state = block.getStateByPrefix(strings[1]);
                }
                boolean isAir = false;
                if (strings.length > 2) {
                    mask = CommandBase.func_147180_g((ICommandSender)sender, (String)strings[2]);
                    if (strings[1].equalsIgnoreCase("air")) {
                        mask = Blocks.field_150350_a;
                        isAir = true;
                    }
                } else {
                    mask = Blocks.field_150350_a;
                    isAir = true;
                }
                if (brush.location1 != null && brush.location2 != null) {
                    ArrayList<Object> list = new ArrayList();
                    if (strings[0].equalsIgnoreCase("cube")) {
                        list = WorldEditHelper.selectCubeFromTwoPoints(brush.location1, brush.location2);
                    }
                    if (strings[0].equalsIgnoreCase("circle")) {
                        list = WorldEditHelper.selectCircleFromTwoPoints(brush.location1, brush.location2);
                    }
                    if (strings[0].equalsIgnoreCase("cube") || strings[0].equalsIgnoreCase("circle")) {
                        int count = 0;
                        for (Location location : list) {
                            if (location.getBlock() != mask) continue;
                            ++count;
                        }
                        this.generate(list, state, mask, isAir, player, count);
                        return;
                    }
                    if (strings[0].equalsIgnoreCase("move")) {
                        ItemBrush.getMessage(player).printMessage(TextFormatting.RED, "Not implemented yet!");
                    }
                } else {
                    ItemBrush.getMessage(player).printMessage(TextFormatting.RED, "You need to set two positions!");
                }
            } else {
                ChatHelper.printModMessage(TextFormatting.RED, "You need to hold a Brush!", player);
            }
        }
    }

    private void generate(ArrayList<Location> list, IBlockState block, Block mask, boolean isAirMask, EntityPlayer player, int amount) {
        WorldEditHelper.generateCommand(list, block, mask, isAirMask, player, ItemBrush.getMessage(player));
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public int func_82362_a() {
        return CUConfig.misc.usePermission ? 2 : 0;
    }
}

