/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.config;

import calemiutils.util.CoinColor;
import com.google.gson.JsonObject;
import java.util.function.BooleanSupplier;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.crafting.IConditionFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="calemiutils", name="CalemiUtils/CalemiUtils")
@Config.LangKey(value="config.title")
public class CUConfig
implements IConditionFactory {
    public static final CategoryItemUtils itemUtils = new CategoryItemUtils();
    public static final CategoryBlockUtils blockUtils = new CategoryBlockUtils();
    public static final CategoryTooltips tooltips = new CategoryTooltips();
    public static final CategoryWorldGen worldGen = new CategoryWorldGen();
    public static final CategoryBlockScans blockScans = new CategoryBlockScans();
    public static final CategoryEconomy economy = new CategoryEconomy();
    public static final CategoryWallet wallet = new CategoryWallet();
    public static final CategoryBuildingUnit buildingUnit = new CategoryBuildingUnit();
    public static final CategoryMisc misc = new CategoryMisc();
    private static final String NEEDED_FOR_SERVERS = "(Only needed on Servers)";

    public BooleanSupplier parse(JsonContext context, JsonObject json) {
        return () -> CUConfig.economy.currencyRecipes;
    }

    @Mod.EventBusSubscriber(modid="calemiutils")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("calemiutils")) {
                ConfigManager.sync((String)"calemiutils", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class CategoryMisc {
        @Config.Name(value="Use Permission for Commands")
        @Config.Comment(value={"(Only needed on Servers) Enable this to restrict non-ops from using cu commands."})
        public boolean usePermission = false;
        @Config.Name(value="Use Security")
        @Config.Comment(value={"Disable this to allow everyone access to anyone's blocks."})
        public boolean useSecurity = true;
        @Config.Name(value="Make Blueprint Passable")
        @Config.Comment(value={"Enable this to allow players to pass through Blueprint."})
        public boolean blueprintPassable = false;
        @Config.Name(value="Bank Currency Capacity")
        @Config.Comment(value={"The max amount of currency the Bank can store."})
        @Config.RangeInt(min=0)
        public int bankCurrencyCapacity = 1000000;
        @Config.Name(value="Trading Post Currency Capacity")
        @Config.Comment(value={"The max amount of currency the Trading Post can store."})
        @Config.RangeInt(min=0)
        public int postCurrencyCapacity = 1000000;
        @Config.Name(value="Scaffold Max Height Teleport")
        @Config.Comment(value={"0 to Disable. The max height you can teleport to the top or bottom of a scaffold."})
        @Config.RangeInt(min=0, max=256)
        public int scaffoldMaxHeightTp = 256;
        @Config.Name(value="Torch Place Max Range")
        @Config.Comment(value={"The max range the Torch Place can place torches."})
        @Config.RangeInt(min=10, max=48)
        public int torchPlacerMaxRange = 48;
        @Config.Name(value="Mining Unit Max Range")
        @Config.Comment(value={"The max range the Mining Unit can mine blocks."})
        @Config.RangeInt(min=10, max=64)
        public int miningUnitMaxRange = 32;
        @Config.Name(value="Upgrade Stack Size")
        @Config.Comment(value={"The max range the Torch Place can place torches."})
        @Config.RangeInt(min=1, max=64)
        public int upgradeStackSize = 5;
        @Config.Name(value="Speed Upgrade Cost Multiplier")
        @Config.Comment(value={"This value is multiplied and added to the current cost of the Unit. This value increases based on how many Speed Upgrades are in the slot."})
        @Config.RangeDouble(min=0.0)
        public double speedUpgradeCostMultiplier = 0.0;
        @Config.Name(value="Blender Max Juice")
        @Config.Comment(value={"0 to Disable. The max height amount of juice the blender can store."})
        @Config.RangeInt(min=0, max=1000000)
        public int blenderMaxJuice = 1000;
        @Config.Name(value="Quarry Unit RC Cost")
        @Config.Comment(value={"The cost of every block the Quarry Unit mines."})
        @Config.RangeInt(min=0)
        public int quarryUnitCost = 1;
        @Config.Name(value="Builders' Kit Block Capacity")
        @Config.Comment(value={"The max amount of block the Builders' Kit can store."})
        @Config.RangeInt(min=0, max=100000)
        public int buildersKitCapacity = 100000;
    }

    public static class CategoryBuildingUnit {
        @Config.Name(value="Building Unit Horizontal Max Range")
        @Config.Comment(value={"The max range the Building Unit can scan for blueprints horizontally."})
        @Config.RangeInt(min=1, max=128)
        public int buildingUnitHorizontalMaxRange = 64;
        @Config.Name(value="Building Unit Vertical Max Range")
        @Config.Comment(value={"The max range the Building Unit can scan for blueprints vertically."})
        @Config.RangeInt(min=1, max=256)
        public int buildingUnitVerticalMaxRange = 64;
        @Config.Name(value="Building Unit Render Box Size")
        @Config.Comment(value={"The size of a box that determines whether to render the ghost Blueprints around the unit."})
        @Config.RangeInt(min=1, max=64)
        public int buildingUnitRenderBoxSize = 16;
        @Config.Name(value="Building Unit Max Block Size")
        @Config.Comment(value={"The size of a box that determines whether to render the ghost Blueprints around the unit."})
        @Config.RangeInt(min=1, max=2000)
        public int buildingUnitBlockSize = 1500;
    }

    public static class CategoryWallet {
        @Config.Name(value="Wallet Currency Capacity")
        @Config.Comment(value={"The max amount of currency the Wallet can store."})
        @Config.RangeInt(min=0, max=99999999)
        public int walletCurrencyCapacity = 99999999;
        @Config.Name(value="Give Starting Wallet")
        @Config.Comment(value={"Enable this to give players a wallet the first time they join the world."})
        public boolean startingWallet = false;
        @Config.Name(value="Keep Wallets on Death")
        @Config.Comment(value={"Enable this to spawn any wallets at the player spawnpoint when they die."})
        public boolean keepWallet = false;
        @Config.Name(value="Render Wallet Currency Overlay")
        @Config.Comment(value={"Enable this render an overlay on your game screen showing your wallet stats."})
        public boolean walletOverlay = true;
    }

    public static class CategoryEconomy {
        @Config.Name(value="Enable Economy")
        @Config.Comment(value={"Disable this to remove Economy and everything that uses it."})
        public boolean economy = true;
        @Config.Name(value="Enable Coin Recipes")
        @Config.Comment(value={"Disable this to remove the recipes for the coins."})
        boolean currencyRecipes = true;
        @Config.Name(value="Currency Name")
        @Config.Comment(value={"Edit this name to change the name of the currency for everything. Try to keep it small."})
        public String currencyName = "RC";
        @Config.Name(value="Penny Name")
        @Config.Comment(value={"Edit this name to change the name of the Penny."})
        public String pennyName = "Penny";
        @Config.Name(value="Penny Color")
        @Config.Comment(value={"Edit this name to change the color of the Penny."})
        public CoinColor pennyColor = CoinColor.BRONZE;
        @Config.Name(value="Penny Value")
        @Config.Comment(value={"Edit this name to change the value of the Penny."})
        @Config.RangeInt(min=0, max=10000)
        public int pennyValue = 1;
        @Config.Name(value="Nickel Name")
        @Config.Comment(value={"Edit this name to change the name of the Nickel."})
        public String nickelName = "Nickel";
        @Config.Name(value="Nickel Color")
        @Config.Comment(value={"Edit this name to change the color of the Nickel."})
        public CoinColor nickelColor = CoinColor.GRAY;
        @Config.Name(value="Nickel Value")
        @Config.Comment(value={"Edit this name to change the value of the Nickel."})
        @Config.RangeInt(min=0, max=10000)
        public int nickelValue = 5;
        @Config.Name(value="Quarter Name")
        @Config.Comment(value={"Edit this name to change the name of the Quarter."})
        public String quarterName = "Quarter";
        @Config.Name(value="Quarter Color")
        @Config.Comment(value={"Edit this name to change the color of the Quarter."})
        public CoinColor quarterColor = CoinColor.SILVER;
        @Config.Name(value="Quarter Value")
        @Config.Comment(value={"Edit this name to change the value of the Quarter."})
        @Config.RangeInt(min=0, max=10000)
        public int quarterValue = 25;
        @Config.Name(value="Dollar Name")
        @Config.Comment(value={"Edit this name to change the name of the Dollar."})
        public String dollarName = "Dollar";
        @Config.Name(value="Dollar Color")
        @Config.Comment(value={"Edit this name to change the color of the Dollar."})
        public CoinColor dollarColor = CoinColor.GOLD;
        @Config.Name(value="Dollar Value")
        @Config.Comment(value={"Edit this name to change the value of the Dollar."})
        @Config.RangeInt(min=0, max=10000)
        public int dollarValue = 100;
    }

    public static class CategoryBlockScans {
        @Config.Name(value="Vein Scan Max Size")
        @Config.Comment(value={"The Vein Scan is a system used by Blueprints, Scaffolds and Networks. It scans for blocks in a chain. The max size is how many chains will occur. Lower values run faster on servers."})
        @Config.RangeInt(min=0, max=1500)
        public int veinScanMaxSize = 1500;
        @Config.Name(value="Brush Max Size")
        @Config.Comment(value={"0 to Disable. The max size of blocks the Brush can place. Lower values run faster on servers."})
        @Config.RangeInt(min=0, max=5000)
        public int worldEditMaxSize = 5000;
    }

    public static class CategoryWorldGen {
        @Config.Name(value="Raritanium Ore Gen")
        @Config.Comment(value={"(Only needed on Servers)"})
        public boolean raritaniumOreGen = true;
        @Config.Name(value="Raritanium Ore Veins Per Chunk")
        @Config.Comment(value={"(Only needed on Servers)"})
        @Config.RangeInt(min=1, max=100)
        public int raritaniumOreVeinsPerChunk = 4;
        @Config.Name(value="Raritanium Vein Size")
        @Config.Comment(value={"(Only needed on Servers)"})
        @Config.RangeInt(min=2, max=32)
        public int raritaniumVeinSize = 8;
        @Config.Name(value="Raritanium Ore Min Y")
        @Config.Comment(value={"(Only needed on Servers)"})
        @Config.RangeInt(min=0, max=256)
        public int raritaniumOreGenMinY = 10;
        @Config.Name(value="Raritanium Ore Max Y")
        @Config.Comment(value={"(Only needed on Servers)"})
        @Config.RangeInt(min=0, max=256)
        public int raritaniumOreGenMaxY = 30;
    }

    public static class CategoryTooltips {
        @Config.Name(value="Show Information on Tooltips")
        public boolean showInfoOnTooltips = true;
        @Config.Name(value="Show Controls on Tooltips")
        public boolean showControlsOnTooltips = true;
    }

    public static class CategoryBlockUtils {
        @Config.Name(value="Enable Raritanium Ore")
        @Config.Comment(value={"Disable this to remove Raritanium Ore."})
        public boolean raritaniumOre = true;
        @Config.Name(value="Enable Blueprint")
        @Config.Comment(value={"Disable this to remove Blueprint and its tools."})
        public boolean blueprint = true;
        @Config.Name(value="Enable Iron Scaffold")
        @Config.Comment(value={"Disable this to remove Iron Scaffold."})
        public boolean ironScaffold = true;
        @Config.Name(value="Enable Torch Placer")
        @Config.Comment(value={"Disable this to remove the Torch Placer."})
        public boolean torchPlacer = true;
        @Config.Name(value="Enable Bank")
        @Config.Comment(value={"Disable this to remove the Bank."})
        public boolean bank = true;
        @Config.Name(value="Enable Network Cable & Gate")
        @Config.Comment(value={"Disable this to remove Network Cable & Gate."})
        public boolean networkCable = true;
        @Config.Name(value="Enable Interaction Interface & Terminal")
        @Config.Comment(value={"Disable this to remove the Interaction Interface & Terminal."})
        public boolean interactionNetwork = true;
        @Config.Name(value="Enable Mining Unit")
        @Config.Comment(value={"Disable this to remove the Mining Unit."})
        public boolean miningUnit = true;
        @Config.Name(value="Enable Quarry Unit")
        @Config.Comment(value={"Disable this to remove the Quarry Unit."})
        public boolean quarryUnit = true;
        @Config.Name(value="Enable Building Unit")
        @Config.Comment(value={"Disable this to remove the Building Unit."})
        public boolean buildingUnit = true;
        @Config.Name(value="Enable Trading Post")
        @Config.Comment(value={"Disable this to remove the Trading Post."})
        public boolean tradingPost = true;
        @Config.Name(value="Enable Market")
        @Config.Comment(value={"Disable this to remove the Market."})
        public boolean market = true;
        @Config.Name(value="Enable Book Stand")
        @Config.Comment(value={"Disable this to remove the Book Stand."})
        public boolean bookStand = true;
    }

    public static class CategoryItemUtils {
        @Config.Name(value="Enable Wood Sledgehammer")
        @Config.Comment(value={"Disable this to remove the Wood Sledgehammer."})
        public boolean wood_sledgehammer = true;
        @Config.Name(value="Enable Stone Sledgehammer")
        @Config.Comment(value={"Disable this to remove the Stone Sledgehammer."})
        public boolean stone_sledgehammer = true;
        @Config.Name(value="Enable Iron Sledgehammer")
        @Config.Comment(value={"Disable this to remove the Iron Sledgehammer."})
        public boolean iron_sledgehammer = true;
        @Config.Name(value="Enable Gold Sledgehammer")
        @Config.Comment(value={"Disable this to remove the Gold Sledgehammer."})
        public boolean gold_sledgehammer = true;
        @Config.Name(value="Enable Diamond Sledgehammer")
        @Config.Comment(value={"Disable this to remove the Diamond Sledgehammer."})
        public boolean diamond_sledgehammer = true;
        @Config.Name(value="Enable Starlight Sledgehammer")
        @Config.Comment(value={"Disable this to remove the Starlight Sledgehammer."})
        public boolean starlight_sledgehammer = true;
        @Config.Name(value="Enable Wallet")
        @Config.Comment(value={"Disable this to remove the Wallet."})
        public boolean wallet = true;
        @Config.Name(value="Enable Security Wrench")
        @Config.Comment(value={"Disable this to remove the Security Wrench."})
        public boolean securityWrench = true;
        @Config.Name(value="Enable Pencil")
        @Config.Comment(value={"Disable this to remove the Pencil."})
        public boolean pencil = true;
        @Config.Name(value="Enable Brush")
        @Config.Comment(value={"Disable this to remove the Brush"})
        public boolean brush = true;
        @Config.Name(value="Enable Eraser")
        @Config.Comment(value={"Disable this to remove the Eraser."})
        public boolean eraser = true;
        @Config.Name(value="Enable Builders' Kit")
        @Config.Comment(value={"Disable this to remove the Builders' Kit."})
        public boolean buildersKit = true;
        @Config.Name(value="Enable Blender")
        @Config.Comment(value={"Disable this to remove the Blender."})
        public boolean blender = true;
        @Config.Name(value="Enable Torch Belt")
        @Config.Comment(value={"Disable this to remove the Torch Belt."})
        public boolean torchBelt = true;
        @Config.Name(value="Enable Location Link Book")
        @Config.Comment(value={"Disable this to remove the Location Link Book."})
        public boolean locationLinkBook = true;
        @Config.Name(value="Enable Upgrades")
        @Config.Comment(value={"Disable this to remove the Upgrades."})
        public boolean upgrades = true;
    }
}

