/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;

public class MarketItemsFile {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
    public static Map<String, MarketItem> registeredBlocks = new HashMap<String, MarketItem>();

    public static void init() {
        File jsonConfig = new File(Loader.instance().getConfigDir() + "/CalemiUtils", "MarketItems.json");
        try {
            if (!jsonConfig.exists() && jsonConfig.createNewFile()) {
                Map<String, MarketItem> defaultMap = MarketItemsFile.getDefaults();
                String json = gson.toJson(defaultMap, new TypeToken<Map<String, MarketItem>>(){}.getType());
                FileWriter writer = new FileWriter(jsonConfig);
                writer.write(json);
                writer.close();
            }
            registeredBlocks = (Map)gson.fromJson((Reader)new FileReader(jsonConfig), new TypeToken<Map<String, MarketItem>>(){}.getType());
        }
        catch (IOException e) {
            System.out.println("Error creating default configuration.");
        }
    }

    private static Map<String, MarketItem> getDefaults() {
        HashMap<String, MarketItem> ret = new HashMap<String, MarketItem>();
        MarketItemsFile.addDefault(ret, 0, "BreadBuy", "minecraft:bread", 0, 4, 2, true);
        MarketItemsFile.addDefault(ret, 1, "SteakBuy", "minecraft:cooked_beef", 0, 4, 6, true);
        MarketItemsFile.addDefault(ret, 2, "GoldenAppleBuy", "minecraft:golden_apple", 1, 1, 128, true);
        MarketItemsFile.addDefault(ret, 3, "CobbleBuy", "minecraft:cobblestone", 0, 128, 32, true);
        MarketItemsFile.addDefault(ret, 4, "OakPlanksBuy", "minecraft:planks", 0, 16, 16, true);
        MarketItemsFile.addDefault(ret, 5, "OreDictIronSell", "ingotIron", 0, 4, 1, false);
        MarketItemsFile.addDefault(ret, 6, "CobbleSell", "minecraft:cobblestone", 0, 64, 1, false);
        MarketItemsFile.addDefault(ret, 7, "DiamondSell", "minecraft:diamond", 0, 1, 64, false);
        MarketItemsFile.addDefault(ret, 8, "EmeraldSell", "minecraft:emerald", 0, 1, 16, false);
        return ret;
    }

    private static void addDefault(Map<String, MarketItem> ret, int index, String stackName, String stackObj, int meta, int amount, int value, boolean isBuy) {
        ret.put(stackName, new MarketItem(index, stackObj, meta, amount, value, isBuy));
    }

    public static class MarketItem {
        public final int index;
        public final String stackObj;
        public final int meta;
        public final int amount;
        public final int value;
        public final boolean isBuy;

        MarketItem(int index, String stackObj, int meta, int amount, int value, boolean isBuy) {
            this.index = index;
            this.stackObj = stackObj;
            this.meta = meta;
            this.amount = amount;
            this.value = value;
            this.isBuy = isBuy;
        }

        public static ItemStack getStack(String stackObj, int amount, int meta) {
            Item item = Item.func_111206_d((String)stackObj);
            if (item != null) {
                return new ItemStack(item, amount, meta);
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack getStack() {
            return MarketItem.getStack(this.stackObj, this.amount, this.meta);
        }

        public static boolean doesOreNameExist(String stackObj) {
            return OreDictionary.doesOreNameExist((String)stackObj);
        }

        public static ItemStack[] getStacksFromOreDict(String stackObj) {
            NonNullList list = OreDictionary.getOres((String)stackObj);
            ItemStack[] stacks = new ItemStack[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                stacks[i] = (ItemStack)list.get(i);
            }
            return stacks;
        }

        public static MarketItem readFromNBT(NBTTagCompound nbt) {
            return new MarketItem(nbt.func_74762_e("index"), nbt.func_74779_i("stackObj"), nbt.func_74762_e("meta"), nbt.func_74762_e("amount"), nbt.func_74762_e("value"), nbt.func_74767_n("isBuy"));
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("index", this.index);
            nbt.func_74778_a("stackObj", this.stackObj);
            nbt.func_74768_a("meta", this.meta);
            nbt.func_74768_a("amount", this.amount);
            nbt.func_74768_a("value", this.value);
            nbt.func_74757_a("isBuy", this.isBuy);
            return nbt;
        }
    }
}

