/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;

public class MiningUnitCostsFile {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
    public static Map<String, BlockInformation> registeredBlocks = new HashMap<String, BlockInformation>();
    public static ArrayList<Item> oreBlocks = new ArrayList();

    public static void init() {
        File jsonConfig = new File(Loader.instance().getConfigDir() + "/CalemiUtils", "MiningUnitCosts.json");
        try {
            if (!jsonConfig.exists() && jsonConfig.createNewFile()) {
                Map<String, BlockInformation> defaultMap = MiningUnitCostsFile.getDefaults();
                String json = gson.toJson(defaultMap, new TypeToken<Map<String, BlockInformation>>(){}.getType());
                FileWriter writer = new FileWriter(jsonConfig);
                writer.write(json);
                writer.close();
            }
            registeredBlocks = (Map)gson.fromJson((Reader)new FileReader(jsonConfig), new TypeToken<Map<String, BlockInformation>>(){}.getType());
        }
        catch (IOException e) {
            System.out.println("Error creating default configuration.");
        }
        for (BlockInformation information : registeredBlocks.values()) {
            Item item = Item.func_111206_d((String)information.oreName);
            if (item == null || Block.func_149634_a((Item)item) == Blocks.field_150350_a) continue;
            oreBlocks.add(item);
        }
    }

    private static Map<String, BlockInformation> getDefaults() {
        HashMap<String, BlockInformation> ret = new HashMap<String, BlockInformation>();
        MiningUnitCostsFile.addDefault(ret, "minecraft:coal", 1);
        MiningUnitCostsFile.addDefault(ret, "oreCopper", 2);
        MiningUnitCostsFile.addDefault(ret, "oreTin", 2);
        MiningUnitCostsFile.addDefault(ret, "oreIron", 2);
        MiningUnitCostsFile.addDefault(ret, "oreAluminum", 3);
        MiningUnitCostsFile.addDefault(ret, "oreLead", 3);
        MiningUnitCostsFile.addDefault(ret, "oreSilver", 4);
        MiningUnitCostsFile.addDefault(ret, "oreGold", 5);
        MiningUnitCostsFile.addDefault(ret, "oreRedstone", 5);
        MiningUnitCostsFile.addDefault(ret, "oreLapis", 5);
        MiningUnitCostsFile.addDefault(ret, "oreRuby", 5);
        MiningUnitCostsFile.addDefault(ret, "oreSapphire", 5);
        MiningUnitCostsFile.addDefault(ret, "oreTopaz", 5);
        MiningUnitCostsFile.addDefault(ret, "oreQuartz", 5);
        MiningUnitCostsFile.addDefault(ret, "oreSulfur", 10);
        MiningUnitCostsFile.addDefault(ret, "oreNickel", 10);
        MiningUnitCostsFile.addDefault(ret, "orePlatinum", 25);
        MiningUnitCostsFile.addDefault(ret, "oreIridium", 25);
        MiningUnitCostsFile.addDefault(ret, "oreManaInfused", 50);
        MiningUnitCostsFile.addDefault(ret, "oreEmerald", 50);
        MiningUnitCostsFile.addDefault(ret, "oreDiamond", 50);
        MiningUnitCostsFile.addDefault(ret, "oreUranium", 50);
        MiningUnitCostsFile.addDefault(ret, "oreCobalt", 50);
        MiningUnitCostsFile.addDefault(ret, "oreArdite", 50);
        return ret;
    }

    private static void addDefault(Map<String, BlockInformation> ret, String name, int cost) {
        ret.put(name, new BlockInformation(name, cost));
    }

    public static class BlockInformation {
        public final String oreName;
        public final int cost;

        BlockInformation(String oreName, int cost) {
            this.oreName = oreName;
            this.cost = cost;
        }

        public static BlockInformation getFromStack(ItemStack stack) {
            for (BlockInformation information : registeredBlocks.values()) {
                for (ItemStack oreStack : OreDictionary.getOres((String)information.oreName)) {
                    if (!ItemStack.func_179545_c((ItemStack)oreStack, (ItemStack)stack)) continue;
                    return information;
                }
                Item item = Item.func_111206_d((String)information.oreName);
                if (item == null) continue;
                return information;
            }
            return null;
        }
    }
}

