/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.event;

import calemiutils.tileentity.TileEntityBuildingUnit;
import calemiutils.tileentity.base.ICurrencyNetworkBank;
import calemiutils.tileentity.base.TileEntityBase;
import calemiutils.util.Location;
import calemiutils.util.helper.ItemHelper;
import calemiutils.util.helper.LoreHelper;
import net.minecraft.block.Block;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WrenchEvent {
    public static void onBlockWrenched(World world, Location location) {
        TileEntityBuildingUnit teBuildingUnit;
        ICurrencyNetworkBank currencyNetwork;
        TileEntity tileEntity = location.getTileEntity();
        ItemStack stack = new ItemStack(Item.func_150898_a((Block)location.getBlock()), 1, location.getBlockMeta());
        if (!world.field_72995_K) {
            ItemHelper.spawnItem(world, location, stack);
        }
        if (tileEntity instanceof ICurrencyNetworkBank && (currencyNetwork = (ICurrencyNetworkBank)tileEntity).getStoredCurrency() > 0) {
            ItemHelper.getNBT(stack).func_74768_a("currency", currencyNetwork.getStoredCurrency());
        }
        if (tileEntity instanceof TileEntityBuildingUnit && !(teBuildingUnit = (TileEntityBuildingUnit)tileEntity).func_191420_l()) {
            ItemStackHelper.func_191282_a((NBTTagCompound)ItemHelper.getNBT(stack), (NonNullList)teBuildingUnit.slots);
        }
        location.setBlockToAir();
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.PlaceEvent event) {
        TileEntity tileEntity = event.getWorld().func_175625_s(event.getPos());
        ItemStack stack = event.getPlayer().func_184586_b(event.getHand());
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlock) {
            if (tileEntity instanceof ICurrencyNetworkBank) {
                ICurrencyNetworkBank currencyNetwork = (ICurrencyNetworkBank)tileEntity;
                if (ItemHelper.getNBT(stack).func_74762_e("currency") != 0) {
                    currencyNetwork.setCurrency(ItemHelper.getNBT(stack).func_74762_e("currency"));
                    ((TileEntityBase)tileEntity).markForUpdate();
                }
            }
            if (tileEntity instanceof TileEntityBuildingUnit) {
                TileEntityBuildingUnit teBuildingUnit = (TileEntityBuildingUnit)tileEntity;
                ItemStackHelper.func_191283_b((NBTTagCompound)ItemHelper.getNBT(stack), (NonNullList)teBuildingUnit.slots);
            }
        }
    }

    @SubscribeEvent
    public void onBlockDestroy(BlockEvent.BreakEvent event) {
        TileEntity tileEntity = event.getWorld().func_175625_s(event.getPos());
        if (tileEntity instanceof TileEntityBuildingUnit) {
            WrenchEvent.onBlockWrenched(event.getWorld(), new Location(tileEntity));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onLoreEvent(ItemTooltipEvent event) {
        int currency;
        if (event.getItemStack().func_77978_p() != null && (currency = ItemHelper.getNBT(event.getItemStack()).func_74762_e("currency")) != 0) {
            event.getToolTip().add("");
            LoreHelper.addCurrencyLore(event.getToolTip(), currency);
        }
    }
}

