/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.gui;

import calemiutils.CalemiUtils;
import calemiutils.config.CUConfig;
import calemiutils.gui.base.GuiButtonRect;
import calemiutils.gui.base.GuiContainerBase;
import calemiutils.item.ItemWallet;
import calemiutils.packet.ServerPacketHandler;
import calemiutils.tileentity.TileEntityBank;
import calemiutils.util.helper.ItemHelper;
import calemiutils.util.helper.MathHelper;
import calemiutils.util.helper.PacketHelper;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiBank
extends GuiContainerBase {
    private final TileEntityBank teBank;
    private GuiButtonRect withdraw;
    private GuiButtonRect deposit;

    public GuiBank(EntityPlayer player, TileEntityBank tileEntity) {
        super(tileEntity.getTileContainer(player), player, tileEntity);
        this.teBank = tileEntity;
    }

    @Override
    public String getGuiTextureName() {
        return "bank";
    }

    @Override
    public String getGuiTitle() {
        return "Bank";
    }

    @Override
    public int getGuiSizeY() {
        return 144;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.withdraw = new GuiButtonRect(0, this.getScreenX() + (this.getGuiSizeX() / 2 - 25) + 30, this.getScreenY() + 40, 50, "Withdraw", this.field_146292_n);
        this.deposit = new GuiButtonRect(1, this.getScreenX() + (this.getGuiSizeX() / 2 - 25) - 30, this.getScreenY() + 40, 50, "Deposit", this.field_146292_n);
    }

    protected void func_146284_a(GuiButton button) {
        if (this.teBank.func_70301_a(1) != null && this.teBank.func_70301_a(1).func_77973_b() instanceof ItemWallet) {
            int remainder;
            int amountToAdd;
            ItemWallet wallet = (ItemWallet)this.teBank.func_70301_a(1).func_77973_b();
            int currency = ItemWallet.getBalance(this.teBank.func_70301_a(1));
            NBTTagCompound nbt = ItemHelper.getNBT(this.teBank.func_70301_a(1));
            if (button.field_146127_k == this.deposit.field_146127_k) {
                amountToAdd = MathHelper.getAmountToAdd(this.teBank.storedCurrency, currency, this.teBank.getMaxCurrency());
                if (amountToAdd > 0) {
                    this.teBank.addCurrency(amountToAdd);
                    nbt.func_74768_a("balance", currency - amountToAdd);
                } else {
                    remainder = MathHelper.getRemainder(this.teBank.storedCurrency, currency, this.teBank.getMaxCurrency());
                    if (remainder > 0) {
                        this.teBank.addCurrency(remainder);
                        nbt.func_74768_a("balance", currency - remainder);
                    }
                }
            }
            if (button.field_146127_k == this.withdraw.field_146127_k) {
                amountToAdd = MathHelper.getAmountToAdd(currency, this.teBank.storedCurrency, CUConfig.wallet.walletCurrencyCapacity);
                if (amountToAdd > 0) {
                    this.teBank.addCurrency(-amountToAdd);
                    nbt.func_74768_a("balance", currency + amountToAdd);
                } else {
                    remainder = MathHelper.getRemainder(currency, this.teBank.storedCurrency, CUConfig.wallet.walletCurrencyCapacity);
                    if (remainder > 0) {
                        this.teBank.addCurrency(-remainder);
                        nbt.func_74768_a("balance", currency + remainder);
                    }
                }
            }
            CalemiUtils.network.sendToServer((IMessage)new ServerPacketHandler("bank-sync%" + this.teBank.storedCurrency + "%" + ItemWallet.getBalance(this.teBank.func_70301_a(1)) + "%" + PacketHelper.sendLocation(this.teBank.getLocation())));
        }
    }

    @Override
    public void drawGuiBackground(int mouseX, int mouseY) {
    }

    @Override
    public void drawGuiForeground(int mouseX, int mouseY) {
        if (!this.teBank.enable) {
            this.addInfoIcon(1);
            this.addInfoIconText(mouseX, mouseY, "Inactive!", "Another Bank is connected in the network!");
        }
    }
}

