/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.gui;

import calemiutils.CUReference;
import calemiutils.CalemiUtils;
import calemiutils.blueprint.BlueprintBuild;
import calemiutils.gui.base.GuiButtonRect;
import calemiutils.gui.base.GuiRect;
import calemiutils.gui.base.GuiScreenBase;
import calemiutils.gui.base.GuiTextFieldRect;
import calemiutils.packet.BuildingUnitPacket;
import calemiutils.tileentity.TileEntityBuildingUnit;
import calemiutils.util.helper.GuiHelper;
import calemiutils.util.helper.PacketHelper;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiBuildingUnit
extends GuiScreenBase {
    private final TileEntityBuildingUnit teBuildingUnit;
    private GuiButtonRect upBtn;
    private GuiButtonRect downBtn;
    private GuiButtonRect buildBtn;
    private GuiButtonRect readBlueprintsBtn;
    private GuiButtonRect rotateBtn;
    private GuiTextFieldRect nameField;

    public GuiBuildingUnit(EntityPlayer player, TileEntityBuildingUnit te) {
        super(player);
        this.teBuildingUnit = te;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.upBtn = new GuiButtonRect(0, this.getScreenX() - 85, this.getScreenY() - 66, 16, "/\\", this.field_146292_n);
        this.downBtn = new GuiButtonRect(1, this.getScreenX() - 85, this.getScreenY() + 50, 16, "\\/", this.field_146292_n);
        this.rotateBtn = new GuiButtonRect(2, this.getScreenX() - 24, this.getScreenY() - 20, 48, "Rotate", this.field_146292_n);
        this.buildBtn = new GuiButtonRect(3, this.getScreenX() - 24, this.getScreenY() + 4, 48, "Build", this.field_146292_n);
        int fieldWidth = 120;
        this.nameField = new GuiTextFieldRect(4, this.field_146289_q, this.getScreenX() + this.getGuiSizeX() / 2 + 40, this.getScreenY() - 20, fieldWidth, 32);
        this.readBlueprintsBtn = new GuiButtonRect(5, this.getScreenX() + this.getGuiSizeX() / 2 + 40 + fieldWidth / 2 - 43, this.getScreenY() + 4, 87, "Read Blueprints", this.field_146292_n);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == this.upBtn.field_146127_k) {
            --this.teBuildingUnit.currentBuildBlueprint;
        }
        if (button.field_146127_k == this.downBtn.field_146127_k) {
            ++this.teBuildingUnit.currentBuildBlueprint;
        }
        if (button.field_146127_k == this.buildBtn.field_146127_k) {
            this.teBuildingUnit.placeBlueprints();
            CalemiUtils.network.sendToServer((IMessage)new BuildingUnitPacket("build%" + PacketHelper.sendLocation(this.teBuildingUnit.getLocation())));
            return;
        }
        if (button.field_146127_k == this.readBlueprintsBtn.field_146127_k) {
            CalemiUtils.network.sendToServer((IMessage)new BuildingUnitPacket("readblueprints%" + PacketHelper.sendLocation(this.teBuildingUnit.getLocation()) + this.nameField.func_146179_b()));
            return;
        }
        if (button.field_146127_k == this.rotateBtn.field_146127_k) {
            this.teBuildingUnit.addRotation();
            CalemiUtils.network.sendToServer((IMessage)new BuildingUnitPacket("rotate%" + PacketHelper.sendLocation(this.teBuildingUnit.getLocation())));
            return;
        }
        this.wrapBuildBlueprintIndexes();
    }

    private List<BlueprintBuild> getBuildBlueprints() {
        return this.teBuildingUnit.buildBlueprints;
    }

    private void wrapBuildBlueprintIndexes() {
        int size = this.getBuildBlueprints().size();
        if (size > 0) {
            this.getBuildBlueprints().size();
            this.teBuildingUnit.currentBuildBlueprint %= size;
            if (this.teBuildingUnit.currentBuildBlueprint < 0) {
                this.teBuildingUnit.currentBuildBlueprint = size - 1;
            }
            CalemiUtils.network.sendToServer((IMessage)new BuildingUnitPacket("synccurrentbuildblueprint%" + PacketHelper.sendLocation(this.teBuildingUnit.getLocation()) + this.teBuildingUnit.currentBuildBlueprint));
        }
    }

    public void func_73876_c() {
        if (this.teBuildingUnit == null) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    @Override
    public void drawGuiBackground(int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GlStateManager.func_179147_l();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(CUReference.GUI_TEXTURES);
        GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
        GuiHelper.drawRect(0, this.getScreenY() - 95, 0, 1, 0, this.field_146294_l, 18);
        GL11.glPopMatrix();
        this.nameField.func_146194_f();
        GuiHelper.drawCenteredString("Building Unit", this.getScreenX(), this.getScreenY() - 90, 0xFFFFFF);
        int range = 4;
        for (int i = -range; i <= range; ++i) {
            if (i + this.teBuildingUnit.currentBuildBlueprint < 0 || i + this.teBuildingUnit.currentBuildBlueprint >= this.teBuildingUnit.buildBlueprints.size()) continue;
            String name = null;
            BlueprintBuild blueprint = this.getBuildBlueprints().get(i + this.teBuildingUnit.currentBuildBlueprint);
            if (blueprint != null) {
                name = blueprint.name;
            }
            if (name == null) continue;
            GuiHelper.drawLimitedString((i == 0 ? "> " : "") + name, this.getScreenX() - 115, this.getScreenY() - 4 + i * 10, 12, 0xFFFFFF);
            GuiHelper.drawHoveringTextBox(mouseX, mouseY, 1, new GuiRect(this.getScreenX() - 115, this.getScreenY() - 4 + i * 10, 78, 9), name);
        }
    }

    @Override
    public void drawGuiForeground(int mouseX, int mouseY) {
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    public String getGuiTextureName() {
        return null;
    }

    @Override
    protected int getGuiSizeX() {
        return 0;
    }

    @Override
    public int getGuiSizeY() {
        return 0;
    }

    @Override
    protected void func_73869_a(char c, int i) throws IOException {
        this.nameField.func_146201_a(c, i);
        if (!this.nameField.func_146206_l()) {
            super.func_73869_a(c, i);
        }
    }

    protected void func_73864_a(int x, int y, int i) throws IOException {
        super.func_73864_a(x, y, i);
        this.nameField.func_146192_a(x, y, i);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0) {
            if (i > 0) {
                --this.teBuildingUnit.currentBuildBlueprint;
            }
            if (i < 0) {
                ++this.teBuildingUnit.currentBuildBlueprint;
            }
            this.wrapBuildBlueprintIndexes();
        }
    }

    @Override
    public boolean canCloseWithInvKey() {
        return true;
    }

    public boolean func_73868_f() {
        return false;
    }
}

