/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.gui;

import calemiutils.CalemiUtils;
import calemiutils.gui.base.GuiButtonRect;
import calemiutils.gui.base.GuiContainerBase;
import calemiutils.packet.ServerPacketHandler;
import calemiutils.tileentity.base.TileEntityDiggingUnitBase;
import calemiutils.util.helper.GuiHelper;
import calemiutils.util.helper.PacketHelper;
import calemiutils.util.helper.StringHelper;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiDiggingUnit
extends GuiContainerBase {
    private final TileEntityDiggingUnitBase teDiggingUnit;
    private GuiButtonRect enable;
    private final String name;

    public GuiDiggingUnit(EntityPlayer player, TileEntityDiggingUnitBase te, String name) {
        super(te.getTileContainer(player), player, te);
        this.teDiggingUnit = te;
        this.name = name;
    }

    @Override
    public int getGuiSizeY() {
        return 225;
    }

    @Override
    public String getGuiTextureName() {
        return "digging_unit";
    }

    @Override
    public String getGuiTitle() {
        return this.name;
    }

    private String getEnabledText() {
        return this.te.enable ? "Enabled" : "Disabled";
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int btnWidth = 62;
        this.enable = new GuiButtonRect(0, this.getScreenX() + this.getGuiSizeX() / 2 - btnWidth / 2, this.getScreenY() + 60, btnWidth, this.getEnabledText(), this.field_146292_n);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.enable.field_146126_j = this.getEnabledText();
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == this.enable.field_146127_k) {
            boolean value = !this.te.enable;
            CalemiUtils.network.sendToServer((IMessage)new ServerPacketHandler("te-enable%" + PacketHelper.sendLocation(this.te.getLocation()) + value));
            this.te.enable = value;
        }
    }

    @Override
    public void drawGuiBackground(int mouseX, int mouseY) {
        GuiHelper.drawCenteredString("Range: " + this.teDiggingUnit.currentRange, this.getScreenX() + this.getGuiSizeX() / 2 + 58, this.getScreenY() + 19, 0x555555);
        GuiHelper.drawCenteredString("Max: " + this.teDiggingUnit.getScaledRange(), this.getScreenX() + this.getGuiSizeX() / 2 + 58, this.getScreenY() + 29, 0x555555);
        GuiHelper.drawCenteredString("To Mine:", this.getScreenX() + this.getGuiSizeX() / 2 - 58, this.getScreenY() + 19, 0x555555);
        GuiHelper.drawCenteredString("" + this.teDiggingUnit.locationsToMine.size(), this.getScreenX() + this.getGuiSizeX() / 2 - 58, this.getScreenY() + 29, 0x555555);
        if (this.teDiggingUnit.getCurrentLocationStack() != null) {
            GuiHelper.drawItemStack(this.field_146296_j, this.teDiggingUnit.getCurrentLocationStack(), this.getScreenX() + 80, this.getScreenY() + 19);
            GuiHelper.drawCenteredString(this.teDiggingUnit.getCurrentLocationStack().func_82833_r(), this.getScreenX() + this.getGuiSizeX() / 2, this.getScreenY() + 39, 0x555555);
            GuiHelper.drawCenteredString("Cost: " + StringHelper.printCurrency(this.teDiggingUnit.getCurrentOreCost()), this.getScreenX() + this.getGuiSizeX() / 2, this.getScreenY() + 49, 0x555555);
        }
    }

    @Override
    public void drawGuiForeground(int mouseX, int mouseY) {
        if (this.teDiggingUnit.getBank() != null) {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.addCurrencyInfo(mouseX, mouseY, this.teDiggingUnit.getBank().getStoredCurrency(), this.teDiggingUnit.getBank().getMaxCurrency());
        }
    }
}

