/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.gui;

import calemiutils.CUReference;
import calemiutils.CalemiUtils;
import calemiutils.gui.base.GuiInteractionButton;
import calemiutils.gui.base.GuiInteractionTab;
import calemiutils.gui.base.GuiScreenBase;
import calemiutils.gui.base.GuiTextFieldRect;
import calemiutils.init.InitBlocks;
import calemiutils.item.ItemInteractionInterfaceFilter;
import calemiutils.packet.InteractionUnitPacket;
import calemiutils.tileentity.TileEntityInteractionInterface;
import calemiutils.tileentity.TileEntityInteractionTerminal;
import calemiutils.util.Location;
import calemiutils.util.helper.GuiHelper;
import calemiutils.util.helper.PacketHelper;
import calemiutils.util.helper.SecurityHelper;
import calemiutils.util.helper.ShiftHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiInteractionTerminal
extends GuiScreenBase {
    private final List<GuiInteractionTab> tabs = new ArrayList<GuiInteractionTab>();
    private GuiInteractionTab activeTab;
    private boolean hasMainTab = false;
    private int id = 0;
    private int offset;
    private final TileEntityInteractionTerminal teTerminal;
    private GuiTextFieldRect searchField;

    public GuiInteractionTerminal(EntityPlayer player, TileEntityInteractionTerminal te) {
        super(player);
        this.teTerminal = te;
    }

    private int getButtonId() {
        ++this.id;
        return this.id;
    }

    private void setActiveTab(GuiInteractionTab tab) {
        for (GuiInteractionTab otherTab : this.tabs) {
            otherTab.enableButtons(false);
        }
        tab.enableButtons(true);
        this.activeTab = tab;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        super.func_73866_w_();
        this.offset = 0;
        int x = this.getScreenX() - 80;
        int y = this.getScreenY() - 75;
        GuiInteractionTab mainTab = new GuiInteractionTab(this.field_146292_n, this.field_146296_j, new ItemStack(InitBlocks.INTERACTION_TERMINAL), "Main", "", x, y, x);
        if (this.teTerminal != null) {
            for (Location blockLocation : this.teTerminal.blocksToInteract) {
                Location interfaceUnit = new Location(blockLocation, EnumFacing.DOWN);
                if (this.teTerminal.isValidFilter(interfaceUnit)) {
                    this.searchForTabs(blockLocation, interfaceUnit, x, y);
                    continue;
                }
                mainTab.addButton(this.getButtonId(), (TileEntityInteractionInterface)interfaceUnit.getTileEntity(), blockLocation, this.player);
            }
        }
        if (mainTab.buttons.size() > 0 || this.tabs.size() == 0) {
            this.tabs.add(0, mainTab);
            this.setActiveTab(mainTab);
            this.hasMainTab = true;
        } else {
            this.setActiveTab(this.tabs.get(0));
        }
        int fieldWidth = 120;
        this.searchField = new GuiTextFieldRect(0, this.field_146289_q, this.getScreenX() + this.getGuiSizeX() / 2 - fieldWidth / 2 - 1, this.getScreenY() + 75, fieldWidth, 32);
    }

    private void searchForTabs(Location blockLocation, Location interfaceUnit, int x, int y) {
        for (GuiInteractionTab tab : this.tabs) {
            if (!ItemInteractionInterfaceFilter.isSameFilter(tab.filter, this.teTerminal.getFilterStack(interfaceUnit))) continue;
            tab.addButton(this.getButtonId(), (TileEntityInteractionInterface)interfaceUnit.getTileEntity(), blockLocation, this.player);
            return;
        }
        if (this.addTab(blockLocation, interfaceUnit, x, y) == null) {
            this.tabs.get(0).addButton(this.getButtonId(), (TileEntityInteractionInterface)interfaceUnit.getTileEntity(), blockLocation, this.player);
        }
    }

    private GuiInteractionTab addTab(Location location, Location interfaceUnit, int x, int y) {
        if (this.tabs.size() < 9) {
            GuiInteractionTab newTab = new GuiInteractionTab(this.field_146292_n, this.field_146296_j, this.teTerminal.getFilterStack(interfaceUnit), x, y, x);
            this.tabs.add(newTab);
            newTab.addButton(this.getButtonId(), (TileEntityInteractionInterface)interfaceUnit.getTileEntity(), location, this.player);
            return newTab;
        }
        return null;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        for (int i = 0; i < this.activeTab.buttons.size(); ++i) {
            if (button.field_146127_k != this.activeTab.buttons.get((int)i).field_146127_k) continue;
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187534_aX, (float)0.75f));
            Location location = this.activeTab.buttons.get((int)i).location;
            CalemiUtils.network.sendToServer((IMessage)new InteractionUnitPacket("terminal-interact%" + PacketHelper.sendLocation(location) + ShiftHelper.isShift()));
            this.player.func_70095_a(ShiftHelper.isShift());
            location.getBlock().func_180639_a(this.player.field_70170_p, location.getBlockPos(), location.getBlockState(), this.player, EnumHand.MAIN_HAND, EnumFacing.UP, 0.0f, 0.0f, 0.0f);
        }
    }

    public void func_73876_c() {
        for (int i = 0; i < this.tabs.size(); ++i) {
            this.tabs.get((int)i).rect.x = this.getScreenX() - 80 + i * 18;
            this.tabs.get((int)i).x = this.getScreenX() - 80 + i * 18;
        }
        this.activeTab.buttons.sort((o1, o2) -> o1.field_146126_j.compareToIgnoreCase(o2.field_146126_j));
        if (!this.searchField.func_146179_b().isEmpty()) {
            for (GuiInteractionButton button : this.activeTab.buttons) {
                if (button.field_146126_j.toLowerCase().contains(this.searchField.func_146179_b().toLowerCase())) continue;
                button.field_146124_l = false;
            }
        } else {
            for (GuiInteractionButton button : this.activeTab.buttons) {
                button.field_146124_l = true;
            }
        }
    }

    @Override
    public void drawGuiBackground(int mouseX, int mouseY) {
        GuiHelper.drawCenteredString("Interaction Interface" + SecurityHelper.getSecuredGuiName(this.teTerminal), this.getScreenX(), this.getScreenY() - 90, 0xFFFFFF);
        GuiHelper.drawCenteredString(this.activeTab.name, this.getScreenX(), this.getScreenY() - 53, 0xFFFFFF);
        GuiHelper.drawCenteredString("Search", this.getScreenX(), this.getScreenY() + 93, 0xFFFFFF);
        GL11.glPushMatrix();
        GlStateManager.func_179147_l();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(CUReference.GUI_TEXTURES);
        GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
        GuiHelper.drawRect(0, this.getScreenY() - 76, 0, 1, 50, this.field_146294_l, 18);
        GL11.glPopMatrix();
        for (GuiInteractionTab tab : this.tabs) {
            tab.renderTab(mouseX, mouseY);
        }
        this.activeTab.renderSelectedTab();
        this.activeTab.renderButtons();
        this.searchField.func_146194_f();
    }

    @Override
    public void drawGuiForeground(int mouseX, int mouseY) {
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    public String getGuiTextureName() {
        return null;
    }

    @Override
    protected int getGuiSizeX() {
        return 0;
    }

    @Override
    public int getGuiSizeY() {
        return 0;
    }

    @Override
    protected void func_73869_a(char c, int i) throws IOException {
        this.searchField.func_146201_a(c, i);
        if (!this.searchField.func_146206_l()) {
            super.func_73869_a(c, i);
            this.player.func_70095_a(false);
        }
    }

    protected void func_73864_a(int x, int y, int i) throws IOException {
        super.func_73864_a(x, y, i);
        this.searchField.func_146192_a(x, y, i);
        for (GuiInteractionTab tab : this.tabs) {
            if (!tab.rect.contains(x, y)) continue;
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            this.setActiveTab(tab);
        }
    }

    @Override
    public boolean canCloseWithInvKey() {
        return true;
    }

    public boolean func_73868_f() {
        return false;
    }
}

