/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.gui;

import calemiutils.CalemiUtils;
import calemiutils.gui.base.GuiButtonRect;
import calemiutils.gui.base.GuiScreenBase;
import calemiutils.gui.base.GuiTextFieldRect;
import calemiutils.item.ItemLinkBookLocation;
import calemiutils.packet.LinkBookPacket;
import calemiutils.util.Location;
import calemiutils.util.helper.GuiHelper;
import calemiutils.util.helper.PacketHelper;
import calemiutils.util.helper.SoundHelper;
import java.io.IOException;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiLinkBook
extends GuiScreenBase {
    private final ItemStack stack;
    private GuiTextFieldRect nameField;
    private GuiButtonRect resetBookButton;
    private GuiButtonRect teleportButton;
    private GuiButtonRect bindLocationButton;
    private final boolean isBookInHand;

    public GuiLinkBook(EntityPlayer player, ItemStack stack) {
        super(player);
        this.stack = stack;
        this.isBookInHand = stack != null && !player.func_184614_ca().func_190926_b() && stack.equals(player.func_184614_ca());
    }

    private ItemLinkBookLocation getBook() {
        if (this.stack != null && this.stack.func_77973_b() instanceof ItemLinkBookLocation) {
            return (ItemLinkBookLocation)this.stack.func_77973_b();
        }
        return null;
    }

    private void setName(String name) {
        if (this.isBookInHand && this.getBook() != null) {
            CalemiUtils.network.sendToServer((IMessage)new LinkBookPacket("name%" + name));
            ItemLinkBookLocation.bindName(this.stack, name);
        }
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        super.func_73866_w_();
        if (this.isBookInHand) {
            this.nameField = new GuiTextFieldRect(0, this.field_146289_q, this.getScreenX() - 80 - 8, this.getScreenY() - 50 - 8, 160, 32);
            if (this.stack != null && this.stack.func_82837_s()) {
                this.nameField.func_146180_a(this.stack.func_82833_r());
            }
            new GuiButtonRect(0, this.getScreenX() + 80 - 4, this.getScreenY() - 50 - 8, 16, "+", this.field_146292_n);
            this.bindLocationButton = new GuiButtonRect(2, this.getScreenX() - 50, this.getScreenY() + 35 - 8, 100, "Bind Location", this.field_146292_n);
            this.resetBookButton = new GuiButtonRect(3, this.getScreenX() - 50, this.getScreenY() + 70 - 8, 100, "Reset Book", this.field_146292_n);
        }
        this.teleportButton = new GuiButtonRect(1, this.getScreenX() - 50, this.getScreenY() - 8, 100, "Teleport", this.field_146292_n);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        Location location;
        super.func_146284_a(button);
        if (this.isBookInHand) {
            this.setName(this.nameField.func_146179_b());
            if (button.field_146127_k == this.bindLocationButton.field_146127_k) {
                location = new Location(this.player.field_70170_p, (int)Math.floor(this.player.field_70165_t), (int)Math.floor(this.player.field_70163_u), (int)Math.floor(this.player.field_70161_v));
                int dim = this.player.field_70170_p.field_73011_w.getDimension();
                CalemiUtils.network.sendToServer((IMessage)new LinkBookPacket("bind%" + PacketHelper.sendLocation(location) + dim));
                ItemLinkBookLocation.bindLocation(this.stack, this.player, location, true);
            }
            if (button.field_146127_k == this.resetBookButton.field_146127_k) {
                this.setName("");
                CalemiUtils.network.sendToServer((IMessage)new LinkBookPacket("reset%"));
                ItemLinkBookLocation.resetLocation(this.stack, this.player);
                this.nameField.func_146180_a("");
            }
        }
        if (button.field_146127_k == this.teleportButton.field_146127_k && this.getBook() != null && this.getBook().isLinked(this.stack) && (location = ItemLinkBookLocation.getLinkedLocation(this.player.field_70170_p, this.stack)) != null) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187534_aX, (float)0.75f));
            SoundHelper.playWarp(this.player.field_70170_p, this.player);
            CalemiUtils.network.sendToServer((IMessage)new LinkBookPacket("teleport%" + PacketHelper.sendLocation(location) + ItemLinkBookLocation.getLinkedDimension(this.stack)));
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        Location location = ItemLinkBookLocation.getLinkedLocation(this.player.field_70170_p, this.stack);
        boolean bl = this.teleportButton.field_146124_l = location != null;
        if (this.isBookInHand) {
            this.resetBookButton.field_146124_l = location != null;
        }
    }

    @Override
    public void drawGuiBackground(int mouseX, int mouseY) {
        if (this.isBookInHand) {
            GuiHelper.drawCenteredString("Name Book", this.getScreenX(), this.getScreenY() - 67, 0xFFFFFF);
            this.nameField.func_146194_f();
        }
        if (this.getBook() != null) {
            Location location = ItemLinkBookLocation.getLinkedLocation(this.player.field_70170_p, this.stack);
            String string = "Not set";
            if (this.getBook().isLinked(this.stack) && location != null) {
                GuiHelper.drawCenteredString(this.stack.func_82833_r(), this.getScreenX(), this.getScreenY() - 28, 0xFFFFFF);
                string = location.toString();
            }
            GuiHelper.drawCenteredString(string, this.getScreenX(), this.getScreenY() - 18, 0xFFFFFF);
        }
    }

    @Override
    public void drawGuiForeground(int mouseX, int mouseY) {
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    public String getGuiTextureName() {
        return null;
    }

    @Override
    public int getGuiSizeX() {
        return 0;
    }

    @Override
    public int getGuiSizeY() {
        return 0;
    }

    @Override
    protected void func_73869_a(char c, int i) throws IOException {
        super.func_73869_a(c, i);
        if (this.isBookInHand) {
            this.nameField.func_146201_a(c, i);
        }
        if (this.getBook() != null) {
            this.teleportButton.field_146124_l = this.getBook().isLinked(this.stack);
            if (this.isBookInHand) {
                this.resetBookButton.field_146124_l = this.getBook().isLinked(this.stack);
                if (this.nameField.func_146206_l() && Keyboard.isKeyDown((int)28)) {
                    this.setName(this.nameField.func_146179_b());
                }
            }
        }
    }

    protected void func_73864_a(int x, int y, int i) throws IOException {
        super.func_73864_a(x, y, i);
        if (this.isBookInHand) {
            this.nameField.func_146192_a(x, y, i);
        }
    }

    @Override
    public boolean canCloseWithInvKey() {
        if (this.isBookInHand) {
            return !this.nameField.func_146206_l();
        }
        return true;
    }

    public boolean func_73868_f() {
        return false;
    }
}

