/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.gui;

import calemiutils.CUReference;
import calemiutils.CalemiUtils;
import calemiutils.config.CUConfig;
import calemiutils.config.MarketItemsFile;
import calemiutils.gui.base.GuiButtonRect;
import calemiutils.gui.base.GuiMarketButton;
import calemiutils.gui.base.GuiMarketTab;
import calemiutils.gui.base.GuiScreenBase;
import calemiutils.init.InitBlocks;
import calemiutils.item.ItemWallet;
import calemiutils.packet.MarketPacket;
import calemiutils.tileentity.TileEntityBank;
import calemiutils.tileentity.TileEntityMarket;
import calemiutils.util.UnitChatMessage;
import calemiutils.util.helper.CurrencyHelper;
import calemiutils.util.helper.GuiHelper;
import calemiutils.util.helper.InventoryHelper;
import calemiutils.util.helper.ItemHelper;
import calemiutils.util.helper.PacketHelper;
import calemiutils.util.helper.ShiftHelper;
import calemiutils.util.helper.StringHelper;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiMarket
extends GuiScreenBase {
    private final TileEntityMarket teMarket;
    private int id = 0;
    private GuiMarketTab buyTab;
    private GuiMarketTab sellTab;
    private GuiMarketTab activeTab;
    private GuiButtonRect buyButton;
    private GuiButtonRect automateButton;
    private GuiButtonRect purchaseAmountIncButton;
    private GuiButtonRect purchaseAmountDecButton;

    public GuiMarket(EntityPlayer player, TileEntityMarket te) {
        super(player);
        this.teMarket = te;
    }

    private UnitChatMessage getUnitChatMessage() {
        return new UnitChatMessage("Market", this.player);
    }

    private ItemStack getCurrentWalletStack() {
        return CurrencyHelper.getCurrentWalletStack(this.player);
    }

    private PayType getPaymentTypeFromPrice(int price) {
        int balance;
        TileEntityBank bank = this.teMarket.getBank();
        if (bank != null && bank.getStoredCurrency() >= price) {
            return PayType.BANK;
        }
        if (!this.getCurrentWalletStack().func_190926_b() && (balance = ItemWallet.getBalance(this.getCurrentWalletStack())) >= price) {
            return PayType.WALLET;
        }
        return PayType.UNDEFINED;
    }

    private PayType getPaymentTypeFromSpace(int price) {
        int balance;
        TileEntityBank bank = this.teMarket.getBank();
        if (bank != null && bank.getStoredCurrency() + price <= CUConfig.misc.bankCurrencyCapacity) {
            return PayType.BANK;
        }
        if (!this.getCurrentWalletStack().func_190926_b() && (balance = ItemWallet.getBalance(this.getCurrentWalletStack())) + price <= CUConfig.wallet.walletCurrencyCapacity) {
            return PayType.WALLET;
        }
        return PayType.UNDEFINED;
    }

    private int getCurrencyFromPayType(int price) {
        if (this.getPaymentTypeFromPrice(price) == PayType.BANK) {
            return this.teMarket.getBank().storedCurrency;
        }
        if (this.getPaymentTypeFromPrice(price) == PayType.WALLET) {
            return ItemWallet.getBalance(this.getCurrentWalletStack());
        }
        return 0;
    }

    private int getMaxCurrencyFromPayType(int price) {
        if (this.getPaymentTypeFromSpace(price) == PayType.BANK) {
            return CUConfig.misc.bankCurrencyCapacity;
        }
        if (this.getPaymentTypeFromSpace(price) == PayType.WALLET) {
            return CUConfig.wallet.walletCurrencyCapacity;
        }
        return 0;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.buyTab = new GuiMarketTab(this.field_146292_n, this.field_146296_j, "Buy Items", this.getScreenX() - 30, this.getScreenY() - 53, this.getScreenX() - 80);
        this.sellTab = new GuiMarketTab(this.field_146292_n, this.field_146296_j, "Sell Items", this.getScreenX() + 30, this.getScreenY() - 53, this.getScreenX() - 80);
        for (int i = 0; i < this.teMarket.marketItemList.size(); ++i) {
            MarketItemsFile.MarketItem marketItem = this.teMarket.marketItemList.get(i);
            if (marketItem.isBuy) {
                this.buyTab.addButton(i, marketItem);
                continue;
            }
            this.sellTab.addButton(i, marketItem);
        }
        this.setBuyMode(this.teMarket.buyMode);
        this.setCurrentOffer(this.teMarket.selectedOffer);
        this.buyButton = new GuiButtonRect(this.teMarket.marketItemList.size(), this.getScreenX(), this.getScreenY(), 56, "", this.field_146292_n);
        this.automateButton = new GuiButtonRect(this.teMarket.marketItemList.size() + 1, this.getScreenX() - 37, this.getScreenY() + 50, 75, "", this.field_146292_n);
        this.purchaseAmountIncButton = new GuiButtonRect(this.teMarket.marketItemList.size() + 2, this.getScreenX(), this.getScreenY(), 16, "+", this.field_146292_n);
        this.purchaseAmountDecButton = new GuiButtonRect(this.teMarket.marketItemList.size() + 3, this.getScreenX(), this.getScreenY(), 16, "-", this.field_146292_n);
    }

    @Override
    public void drawGuiBackground(int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GlStateManager.func_179147_l();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(CUReference.GUI_TEXTURES);
        GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
        GuiHelper.drawRect(0, this.getScreenY() - 76, 0, 1, 50, this.field_146294_l, 18);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)100.0f);
        GuiHelper.drawCenteredString("Market", this.getScreenX(), this.getScreenY() - 71, 0xFFFFFF);
        GL11.glPopMatrix();
        int xOffset = 40;
        int yOffset = this.getScreenY() - 36;
        if (this.teMarket.getSelectedOffer() != null) {
            ItemStack[] stacks = !this.teMarket.getSelectedOffer().isBuy && MarketItemsFile.MarketItem.doesOreNameExist(this.teMarket.getSelectedOffer().stackObj) ? MarketItemsFile.MarketItem.getStacksFromOreDict(this.teMarket.getSelectedOffer().stackObj) : new ItemStack[]{this.teMarket.getSelectedOffer().getStack()};
            if (stacks.length > 0) {
                int x = (int)((float)this.field_146294_l / (this.teMarket.automationMode ? 2.3f : 4.0f) - (float)xOffset);
                String name = StringHelper.printCommas(this.teMarket.getSelectedOffer().amount * this.teMarket.purchaseAmount) + "x " + stacks[0].func_82833_r();
                int nameWidth = this.field_146297_k.field_71466_p.func_78256_a(name) - 1;
                GuiHelper.drawItemStack(this.field_146296_j, stacks[0], x - 8, yOffset - 2);
                GuiHelper.drawCenteredString(name, x, yOffset + 18, 0xFFFFFF);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(CUReference.GUI_TEXTURES);
                GuiHelper.drawRect(x - nameWidth / 2 - (nameWidth % 2 == 1 ? 1 : 0), yOffset + 27, 0, 0, 100, nameWidth, 1);
                GuiHelper.drawCenteredString((this.teMarket.buyMode ? "Cost " : "Sell ") + StringHelper.printCurrency(this.teMarket.getSelectedOffer().value * this.teMarket.purchaseAmount), x, yOffset + 32, 0xFFFFFF);
                GuiHelper.drawCenteredString(this.teMarket.purchaseAmount + "x", x, yOffset + 46, 0xFFFFFF);
                this.purchaseAmountIncButton.field_146125_m = true;
                this.purchaseAmountIncButton.setPosition(x - this.purchaseAmountIncButton.field_146120_f / 2 + 20, yOffset + 42);
                this.purchaseAmountDecButton.field_146125_m = true;
                this.purchaseAmountDecButton.setPosition(x - this.purchaseAmountIncButton.field_146120_f / 2 - 20, yOffset + 42);
                this.buyButton.field_146125_m = true;
                this.buyButton.setPosition(x - this.buyButton.field_146120_f / 2, yOffset + 60);
                this.buyButton.field_146126_j = this.teMarket.buyMode ? "Purchase" : "Sell";
            }
        } else {
            this.purchaseAmountIncButton.field_146125_m = false;
            this.purchaseAmountDecButton.field_146125_m = false;
            this.buyButton.field_146125_m = false;
        }
        if (this.teMarket.getBank() != null) {
            int x = (int)((float)(this.field_146294_l / 4) * (this.teMarket.automationMode ? 2.3f : 3.0f) + (float)xOffset);
            GuiHelper.drawItemStack(this.field_146296_j, new ItemStack(InitBlocks.BANK), x - 8, yOffset);
            GuiHelper.drawCenteredString("Balance " + StringHelper.printCurrency(this.teMarket.getBank().storedCurrency), x, yOffset + 18, 0xFFFFFF);
            yOffset += 35;
        }
        if (!this.getCurrentWalletStack().func_190926_b()) {
            int x = (int)((float)(this.field_146294_l / 4) * (this.teMarket.automationMode ? 2.3f : 3.0f) + (float)xOffset);
            GuiHelper.drawItemStack(this.field_146296_j, this.getCurrentWalletStack(), x - 8, yOffset);
            GuiHelper.drawCenteredString("Balance " + StringHelper.printCurrency(ItemWallet.getBalance(this.getCurrentWalletStack())), x, yOffset + 18, 0xFFFFFF);
        }
        this.automateButton.field_146126_j = "Automate: " + (this.teMarket.automationMode ? "ON" : "OFF");
        if (!this.teMarket.automationMode) {
            this.buyTab.renderTab();
            this.sellTab.renderTab();
            if (this.activeTab != null) {
                this.activeTab.renderSelectedTab();
                this.activeTab.renderButtons();
            }
            for (GuiMarketButton button : this.activeTab.buttons) {
                button.field_146124_l = true;
            }
            this.buyButton.field_146125_m = true;
            GuiHelper.drawHoveringTextBox(mouseX, mouseY, 50, this.purchaseAmountIncButton.rect, "Shift: 16, Ctrl: 32, Shift + Ctrl: 64");
            GuiHelper.drawHoveringTextBox(mouseX, mouseY, 50, this.purchaseAmountDecButton.rect, "Shift: 16, Ctrl: 32, Shift + Ctrl: 64");
        } else {
            for (GuiMarketButton button : this.activeTab.buttons) {
                button.field_146124_l = false;
            }
            this.purchaseAmountIncButton.field_146125_m = false;
            this.purchaseAmountDecButton.field_146125_m = false;
            this.buyButton.field_146125_m = false;
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        int multiplier = ShiftHelper.getShiftCtrlInt(1, 16, 32, 64);
        if (button.field_146127_k == this.purchaseAmountIncButton.field_146127_k) {
            int amount;
            this.teMarket.purchaseAmount = amount = MathHelper.func_76125_a((int)(this.teMarket.purchaseAmount + multiplier), (int)1, (int)64);
            CalemiUtils.network.sendToServer((IMessage)new MarketPacket("syncamount%" + PacketHelper.sendLocation(this.teMarket.getLocation()) + amount));
        } else if (button.field_146127_k == this.purchaseAmountDecButton.field_146127_k) {
            int amount;
            this.teMarket.purchaseAmount = amount = MathHelper.func_76125_a((int)(this.teMarket.purchaseAmount - multiplier), (int)1, (int)64);
            CalemiUtils.network.sendToServer((IMessage)new MarketPacket("syncamount%" + PacketHelper.sendLocation(this.teMarket.getLocation()) + amount));
        } else if (button.field_146127_k == this.buyButton.field_146127_k) {
            if (!this.teMarket.automationMode) {
                this.handleTrade();
            }
        } else if (button.field_146127_k == this.automateButton.field_146127_k) {
            this.teMarket.automationMode = !this.teMarket.automationMode;
            CalemiUtils.network.sendToServer((IMessage)new MarketPacket("setautomode%" + PacketHelper.sendLocation(this.teMarket.getLocation()) + this.teMarket.automationMode));
        } else if (!this.teMarket.automationMode) {
            this.setCurrentOffer(button.field_146127_k);
        }
    }

    protected void func_73864_a(int x, int y, int i) throws IOException {
        super.func_73864_a(x, y, i);
        if (!this.teMarket.automationMode) {
            if (this.buyTab.rect.contains(x, y)) {
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.setBuyMode(true);
                if (this.buyTab.buttons.size() > 0) {
                    this.setCurrentOffer(this.buyTab.buttons.get((int)0).field_146127_k);
                }
            }
            if (this.sellTab.rect.contains(x, y)) {
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.setBuyMode(false);
                if (this.sellTab.buttons.size() > 0) {
                    this.setCurrentOffer(this.sellTab.buttons.get((int)0).field_146127_k);
                }
            }
        }
    }

    private void setBuyMode(boolean value) {
        this.sellTab.enableButtons(false);
        this.buyTab.enableButtons(false);
        this.teMarket.buyMode = value;
        CalemiUtils.network.sendToServer((IMessage)new MarketPacket("setbuymode%" + PacketHelper.sendLocation(this.teMarket.getLocation()) + value));
        this.activeTab = this.teMarket.buyMode ? this.buyTab : this.sellTab;
        this.activeTab.enableButtons(true);
    }

    private void setCurrentOffer(int id) {
        this.teMarket.selectedOffer = id;
        CalemiUtils.network.sendToServer((IMessage)new MarketPacket("setoffer%" + PacketHelper.sendLocation(this.teMarket.getLocation()) + id));
    }

    private void handleTrade() {
        if (this.teMarket.getSelectedOffer() != null) {
            MarketItemsFile.MarketItem marketItem = this.teMarket.getSelectedOffer();
            ItemStack[] stacks = !marketItem.isBuy && MarketItemsFile.MarketItem.doesOreNameExist(marketItem.stackObj) ? MarketItemsFile.MarketItem.getStacksFromOreDict(marketItem.stackObj) : new ItemStack[]{marketItem.getStack()};
            ItemStack walletStack = CurrencyHelper.getCurrentWalletStack(this.player);
            if (!walletStack.func_190926_b() || this.teMarket.getBank() != null) {
                int price = marketItem.value * this.teMarket.purchaseAmount;
                int currency = this.getCurrencyFromPayType(price);
                if (marketItem.isBuy) {
                    if (currency >= price) {
                        if (this.getPaymentTypeFromPrice(price) == PayType.WALLET) {
                            ItemHelper.getNBT(walletStack).func_74768_a("balance", ItemHelper.getNBT(walletStack).func_74762_e("balance") - marketItem.value * this.teMarket.purchaseAmount);
                        }
                        CalemiUtils.network.sendToServer((IMessage)new MarketPacket("buy%" + marketItem.stackObj + "%" + marketItem.meta + "%" + marketItem.amount + "%" + marketItem.value + "%" + this.teMarket.purchaseAmount + "%" + (this.getPaymentTypeFromPrice(price) == PayType.BANK ? PacketHelper.sendLocation(this.teMarket.getBank().getLocation()) : "")));
                    } else {
                        this.getUnitChatMessage().printMessage(TextFormatting.RED, "You don't have enough money!");
                    }
                } else if (currency + price <= this.getMaxCurrencyFromPayType(price)) {
                    if (InventoryHelper.countItems((IInventory)this.player.field_71071_by, false, false, stacks) >= marketItem.amount * this.teMarket.purchaseAmount) {
                        InventoryHelper.consumeItem((IInventory)this.player.field_71071_by, marketItem.amount * this.teMarket.purchaseAmount, false, stacks);
                        if (this.getPaymentTypeFromSpace(price) == PayType.WALLET) {
                            ItemHelper.getNBT(walletStack).func_74768_a("balance", ItemHelper.getNBT(walletStack).func_74762_e("balance") + marketItem.value * this.teMarket.purchaseAmount);
                        }
                        CalemiUtils.network.sendToServer((IMessage)new MarketPacket("sell%" + marketItem.stackObj + "%" + marketItem.meta + "%" + marketItem.amount + "%" + marketItem.value + "%" + this.teMarket.purchaseAmount + "%" + (this.getPaymentTypeFromSpace(price) == PayType.BANK ? PacketHelper.sendLocation(this.teMarket.getBank().getLocation()) : "")));
                    } else {
                        this.getUnitChatMessage().printMessage(TextFormatting.RED, "You don't have the required items and amount");
                    }
                } else {
                    this.getUnitChatMessage().printMessage(TextFormatting.RED, "You don't have space for the income!");
                }
            } else {
                this.getUnitChatMessage().printMessage(TextFormatting.RED, "You need to have a wallet or a connected bank!");
            }
        }
    }

    @Override
    public void drawGuiForeground(int mouseX, int mouseY) {
    }

    @Override
    public String getGuiTextureName() {
        return null;
    }

    @Override
    public int getGuiSizeX() {
        return 0;
    }

    @Override
    public int getGuiSizeY() {
        return 0;
    }

    @Override
    public boolean canCloseWithInvKey() {
        return true;
    }

    public boolean func_73868_f() {
        return false;
    }

    public static enum PayType {
        UNDEFINED(0),
        BANK(1),
        WALLET(2);

        final int index;

        private PayType(int index) {
            this.index = index;
        }
    }
}

