/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.gui;

import calemiutils.CalemiUtils;
import calemiutils.gui.base.GuiButtonRect;
import calemiutils.gui.base.GuiContainerBase;
import calemiutils.gui.base.GuiFakeSlot;
import calemiutils.packet.TradingPostPacket;
import calemiutils.tileentity.TileEntityTradingPost;
import calemiutils.util.helper.GuiHelper;
import calemiutils.util.helper.ItemHelper;
import calemiutils.util.helper.PacketHelper;
import calemiutils.util.helper.ShiftHelper;
import calemiutils.util.helper.StringHelper;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiTradingPost
extends GuiContainerBase {
    private final TileEntityTradingPost tePost;
    private GuiButtonRect sellModeButton;
    private GuiFakeSlot fakeSlot;
    private final int upY = 40;
    private final int downY = 59;

    public GuiTradingPost(EntityPlayer player, TileEntityTradingPost te) {
        super(te.getTileContainer(player), player, te);
        this.tePost = te;
    }

    @Override
    public int getGuiSizeY() {
        return 223;
    }

    @Override
    public String getGuiTextureName() {
        return "trading_post";
    }

    @Override
    public String getGuiTitle() {
        return "Trading Post";
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        new GuiButtonRect(0, this.getScreenX() + 49, this.getScreenY() + 40, 16, "-", this.field_146292_n);
        new GuiButtonRect(1, this.getScreenX() + 111, this.getScreenY() + 40, 16, "+", this.field_146292_n);
        new GuiButtonRect(2, this.getScreenX() + 49, this.getScreenY() + 59, 16, "-", this.field_146292_n);
        new GuiButtonRect(3, this.getScreenX() + 111, this.getScreenY() + 59, 16, "+", this.field_146292_n);
        new GuiButtonRect(4, this.getScreenX() + 130, this.getScreenY() + 40, 16, "R", this.field_146292_n);
        new GuiButtonRect(5, this.getScreenX() + 130, this.getScreenY() + 59, 16, "R", this.field_146292_n);
        this.sellModeButton = new GuiButtonRect(6, this.getScreenX() + 21, this.getScreenY() + 19, 39, this.tePost.buyMode ? "Buying" : "Selling", this.field_146292_n);
        this.fakeSlot = new GuiFakeSlot(7, this.getScreenX() + 80, this.getScreenY() + 19, this.field_146296_j, this.field_146292_n);
        this.fakeSlot.setItemStack(this.tePost.getStackForSale());
    }

    protected void func_146284_a(GuiButton button) {
        int i = ShiftHelper.getShiftCtrlInt(1, 10, 100, 1000);
        InventoryPlayer inv = this.field_146297_k.field_71439_g.field_71071_by;
        if (button.field_146127_k == this.fakeSlot.field_146127_k) {
            ItemStack stack = new ItemStack(inv.func_70445_o().func_77973_b(), 1, inv.func_70445_o().func_77960_j());
            if (inv.func_70445_o().func_77942_o()) {
                stack.func_77982_d(inv.func_70445_o().func_77978_p());
            }
            CalemiUtils.network.sendToServer((IMessage)new TradingPostPacket("setstackforsale%" + PacketHelper.sendLocation(this.tePost.getLocation()) + ItemHelper.getStringFromStack(stack) + "%" + ItemHelper.getNBTFromStack(stack)));
            this.tePost.setStackForSale(stack);
            this.fakeSlot.setItemStack(stack);
        } else if (button.field_146127_k == this.sellModeButton.field_146127_k) {
            boolean mode = !this.tePost.buyMode;
            CalemiUtils.network.sendToServer((IMessage)new TradingPostPacket("togglesellmode%" + PacketHelper.sendLocation(this.tePost.getLocation()) + mode));
            this.tePost.buyMode = mode;
        } else {
            if (button.field_146127_k == 0 || button.field_146127_k == 2) {
                i *= -1;
            }
            String str = "";
            int value = 0;
            if (button.field_146127_k == 0 || button.field_146127_k == 1) {
                str = "amount";
                this.tePost.amountForSale += i;
                value = this.tePost.amountForSale;
            }
            if (button.field_146127_k == 2 || button.field_146127_k == 3) {
                str = "price";
                this.tePost.salePrice += i;
                value = this.tePost.salePrice;
            }
            if (button.field_146127_k == 4) {
                str = "amount";
                this.tePost.amountForSale = 1;
                value = 1;
            }
            if (button.field_146127_k == 5) {
                str = "price";
                this.tePost.salePrice = 0;
                value = 0;
            }
            this.tePost.amountForSale = MathHelper.func_76125_a((int)this.tePost.amountForSale, (int)1, (int)1000);
            this.tePost.salePrice = MathHelper.func_76125_a((int)this.tePost.salePrice, (int)0, (int)10000);
            CalemiUtils.network.sendToServer((IMessage)new TradingPostPacket("setoptions%" + str + "%" + value + "%" + this.tePost.func_174877_v().func_177958_n() + "%" + this.tePost.func_174877_v().func_177956_o() + "%" + this.tePost.func_174877_v().func_177952_p()));
        }
    }

    @Override
    public void drawGuiBackground(int mouseX, int mouseY) {
        this.field_146297_k.field_71466_p.func_78276_b("Amount", this.getScreenX() + 10, this.getScreenY() + 40 + 4, 0x555555);
        this.field_146297_k.field_71466_p.func_78276_b("Price", this.getScreenX() + 10, this.getScreenY() + 59 + 4, 0x555555);
        GuiHelper.drawCenteredString(StringHelper.printCommas(this.tePost.amountForSale), this.getScreenX() + this.getGuiSizeX() / 2, this.getScreenY() + 40 + 4, 0x555555);
        GuiHelper.drawCenteredString(StringHelper.printCommas(this.tePost.salePrice), this.getScreenX() + this.getGuiSizeX() / 2, this.getScreenY() + 59 + 4, 0x555555);
        this.sellModeButton.field_146126_j = this.tePost.buyMode ? "Buying" : "Selling";
    }

    @Override
    public void drawGuiForeground(int mouseX, int mouseY) {
        if (this.tePost.getBank() != null) {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.addCurrencyInfo(mouseX, mouseY, this.tePost.getBank().getStoredCurrency(), this.tePost.getBank().getMaxCurrency());
        }
        GL11.glDisable((int)2896);
        this.addInfoIcon(0);
        this.addInfoIconText(mouseX, mouseY, "Button Click Info", "Shift: 10, Ctrl: 100, Shift + Ctrl: 100");
        this.fakeSlot.renderButton(mouseX, mouseY, 150);
    }
}

