/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.gui;

import calemiutils.CalemiUtils;
import calemiutils.config.CUConfig;
import calemiutils.gui.base.GuiButtonRect;
import calemiutils.gui.base.GuiContainerBase;
import calemiutils.init.InitItems;
import calemiutils.inventory.ContainerWallet;
import calemiutils.item.ItemWallet;
import calemiutils.packet.WalletPacket;
import calemiutils.util.helper.CurrencyHelper;
import calemiutils.util.helper.GuiHelper;
import calemiutils.util.helper.ItemHelper;
import calemiutils.util.helper.ShiftHelper;
import calemiutils.util.helper.StringHelper;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiWallet
extends GuiContainerBase {
    private GuiButtonRect toggleSuckButton;
    private GuiButtonRect setActiveButton;

    public GuiWallet(EntityPlayer player) {
        super(new ContainerWallet(player), player);
    }

    @Override
    public String getGuiTextureName() {
        return "wallet";
    }

    @Override
    public String getGuiTitle() {
        return "Wallet";
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        new GuiButtonRect(0, this.getScreenX() + 146, this.getScreenY() + 15, 16, "+", this.field_146292_n);
        new GuiButtonRect(1, this.getScreenX() + 146, this.getScreenY() + 15 + 18, 16, "+", this.field_146292_n);
        new GuiButtonRect(2, this.getScreenX() + 146, this.getScreenY() + 15 + 36, 16, "+", this.field_146292_n);
        new GuiButtonRect(3, this.getScreenX() + 146, this.getScreenY() + 15 + 54, 16, "+", this.field_146292_n);
        this.toggleSuckButton = new GuiButtonRect(4, this.getScreenX() + this.getGuiSizeX() / 2 - 27 - 54, this.getScreenY() + 18 + 54, 54, "", this.field_146292_n);
        this.setActiveButton = new GuiButtonRect(5, this.getScreenX() + this.getGuiSizeX() / 2 - 24, this.getScreenY() + 18 + 54, 48, "Activate", this.field_146292_n);
    }

    private ItemStack getCurrentWalletStack() {
        ItemStack walletStack = CurrencyHelper.getCurrentWalletStack(this.player, false);
        if (!walletStack.func_190926_b()) {
            return walletStack;
        }
        Minecraft.func_71410_x().field_71439_g.func_71053_j();
        return ItemStack.field_190927_a;
    }

    protected void func_146284_a(GuiButton button) {
        int price = InitItems.COIN_PENNY.value;
        if (button.field_146127_k == 1) {
            price = InitItems.COIN_NICKEL.value;
        }
        if (button.field_146127_k == 2) {
            price = InitItems.COIN_QUARTER.value;
        }
        if (button.field_146127_k == 3) {
            price = InitItems.COIN_DOLLAR.value;
        }
        int multiplier = ShiftHelper.getShiftCtrlInt(1, 16, 64, 576);
        price *= multiplier;
        ItemStack walletStack = this.getCurrentWalletStack();
        if (!walletStack.func_190926_b()) {
            ItemWallet walletItem = (ItemWallet)walletStack.func_77973_b();
            if (button.field_146127_k < 4 && ItemWallet.getBalance(walletStack) >= price) {
                if (ItemHelper.getNBT(walletStack).func_74767_n("suck")) {
                    walletItem.toggleSuck(walletStack);
                    CalemiUtils.network.sendToServer((IMessage)new WalletPacket("togglesuck"));
                }
                CalemiUtils.network.sendToServer((IMessage)new WalletPacket("withdraw%" + button.field_146127_k + "%" + multiplier));
                NBTTagCompound nbt = ItemHelper.getNBT(walletStack);
                nbt.func_74768_a("balance", nbt.func_74762_e("balance") - price);
            }
            if (button.field_146127_k == this.toggleSuckButton.field_146127_k) {
                CalemiUtils.network.sendToServer((IMessage)new WalletPacket("togglesuck"));
                walletItem.toggleSuck(walletStack);
            }
            if (button.field_146127_k == this.setActiveButton.field_146127_k) {
                CalemiUtils.network.sendToServer((IMessage)new WalletPacket("activate"));
                List<ItemStack> list = CurrencyHelper.checkForActiveWallets(this.player);
                for (ItemStack stack : list) {
                    ItemWallet.activate(stack, false);
                }
                ItemWallet.activate(walletStack, true);
            }
        }
    }

    @Override
    public void drawGuiBackground(int mouseX, int mouseY) {
        GuiHelper.drawItemStack(this.field_146296_j, new ItemStack((Item)InitItems.COIN_PENNY), this.getScreenX() + 127, this.getScreenY() + 15);
        GuiHelper.drawItemStack(this.field_146296_j, new ItemStack((Item)InitItems.COIN_NICKEL), this.getScreenX() + 127, this.getScreenY() + 33);
        GuiHelper.drawItemStack(this.field_146296_j, new ItemStack((Item)InitItems.COIN_QUARTER), this.getScreenX() + 127, this.getScreenY() + 51);
        GuiHelper.drawItemStack(this.field_146296_j, new ItemStack((Item)InitItems.COIN_DOLLAR), this.getScreenX() + 127, this.getScreenY() + 69);
        GL11.glDisable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemStack stack = this.getCurrentWalletStack();
        if (!stack.func_190926_b()) {
            this.toggleSuckButton.field_146126_j = "Suck: " + (ItemHelper.getNBT(stack).func_74767_n("suck") ? "ON" : "OFF");
            GuiHelper.drawCenteredString(StringHelper.printCommas(ItemHelper.getNBT(stack).func_74762_e("balance")), this.getScreenX() + this.getGuiSizeX() / 2 - 16, this.getScreenY() + 42, 0x555555);
            GuiHelper.drawCenteredString(CUConfig.economy.currencyName, this.getScreenX() + this.getGuiSizeX() / 2 - 16, this.getScreenY() + 51, 0x555555);
        }
    }

    @Override
    public void drawGuiForeground(int mouseX, int mouseY) {
        GL11.glDisable((int)2896);
        this.addInfoIcon(0);
        this.addInfoIconText(mouseX, mouseY, "Button Click Info", "Shift: 16, Ctrl: 64, Shift + Ctrl: 64 * 9");
        if (!ItemWallet.isActive(this.getCurrentWalletStack())) {
            this.leftTabOffset += 17;
            this.addInfoIcon(1);
            this.addInfoIconText(mouseX, mouseY, "Inactive!", "Press the activate button.", "There can only be one active Wallet.");
        }
    }
}

