/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.gui.base;

import calemiutils.gui.base.GuiRect;
import calemiutils.security.ISecurity;
import calemiutils.tileentity.base.ICurrencyNetworkBank;
import calemiutils.tileentity.base.IProgress;
import calemiutils.tileentity.base.TileEntityBase;
import calemiutils.tileentity.base.TileEntityUpgradable;
import calemiutils.util.helper.GuiHelper;
import calemiutils.util.helper.MathHelper;
import calemiutils.util.helper.StringHelper;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import org.lwjgl.opengl.GL11;

public abstract class GuiContainerBase
extends GuiContainer {
    protected static final int TEXT_COLOR = 0x555555;
    protected final EntityPlayer player;
    protected TileEntityBase te;
    public int leftTabOffset;
    private int rightTabOffset;

    protected GuiContainerBase(Container container, EntityPlayer player) {
        super(container);
        this.field_146999_f = this.getGuiSizeX();
        this.field_147000_g = this.getGuiSizeY();
        this.player = player;
        this.leftTabOffset = 4;
        this.rightTabOffset = 4;
    }

    protected GuiContainerBase(Container container, EntityPlayer player, TileEntityBase te) {
        this(container, player);
        this.te = te;
    }

    protected abstract String getGuiTextureName();

    protected abstract String getGuiTitle();

    protected abstract void drawGuiBackground(int var1, int var2);

    protected abstract void drawGuiForeground(int var1, int var2);

    protected int getGuiSizeX() {
        return 176;
    }

    protected int getGuiSizeY() {
        return 176;
    }

    protected int getScreenX() {
        return (this.field_146294_l - this.getGuiSizeX()) / 2;
    }

    protected int getScreenY() {
        return (this.field_146295_m - this.getGuiSizeY()) / 2;
    }

    private void addUpgradeSlot(int index) {
        GuiHelper.bindGuiTextures();
        this.addRightInfoText("", 15, 22);
        GuiHelper.bindGuiTextures();
        GuiHelper.drawRect(this.getScreenX() + this.getGuiSizeX() + 2, this.getScreenY() + 6 + index * 24, index * 18, 19, 5, 18, 18);
    }

    private void addProgressBar(int progress, int maxProgress) {
        GuiHelper.bindGuiTextures();
        GuiRect rect = new GuiRect(this.getScreenX() - 13, this.getScreenY() + this.leftTabOffset, 13, 35);
        int scale = MathHelper.scaleInt(progress, maxProgress, 26);
        GuiHelper.drawRect(rect.x, rect.y, 0, 37, 0, rect.width, rect.height);
        GuiHelper.drawRect(this.getScreenX() - 8, this.getScreenY() + 30 + this.leftTabOffset - scale, 13, 62 - scale, 0, 5, scale);
    }

    private void addProgressBarText(int mouseX, int mouseY, int progress, int maxProgress) {
        GuiRect rect = new GuiRect(this.getScreenX() - 13, this.getScreenY() + this.leftTabOffset, 13, 35);
        GuiHelper.drawHoveringTextBox(mouseX, mouseY, 170, rect, "Progress: " + MathHelper.scaleInt(progress, maxProgress, 100) + "%");
    }

    protected void addInfoIcon(int index) {
        GL11.glDisable((int)2896);
        GuiHelper.bindGuiTextures();
        GuiHelper.drawRect(this.getScreenX() - 13, this.getScreenY() + this.leftTabOffset, index * 13, 72, 2, 13, 15);
    }

    protected void addInfoIconText(int mouseX, int mouseY, String ... text) {
        GuiRect rect = new GuiRect(this.getScreenX() - 13, this.getScreenY() + this.leftTabOffset, 13, 15);
        GuiHelper.drawHoveringTextBox(mouseX, mouseY, 170, rect, text);
    }

    protected void addCurrencyInfo(int mouseX, int mouseY, int currency, int maxCurrency) {
        String fullName = StringHelper.printCommas(currency) + " / " + StringHelper.printCurrency(maxCurrency);
        int fullWidth = this.field_146297_k.field_71466_p.func_78256_a(fullName) + 6;
        GuiRect rect = new GuiRect(this.getScreenX() - fullWidth, this.getScreenY() + this.leftTabOffset, fullWidth, 15);
        String text = StringHelper.printCurrency(currency);
        if (rect.contains(mouseX, mouseY)) {
            text = fullName;
        }
        this.addLeftInfoText(text, 15);
    }

    protected void addRightInfoText(String text, int sizeAdd, int sizeY) {
        int width = this.field_146297_k.field_71466_p.func_78256_a(text) + sizeAdd + 7;
        GuiHelper.bindGuiTextures();
        GuiHelper.drawCappedRect(this.getScreenX() + this.getGuiSizeX(), this.getScreenY() + this.rightTabOffset, 0, 116, 2, width, sizeY, 256, 22);
        if (!text.isEmpty()) {
            GlStateManager.func_179094_E();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)5.0f);
            GL11.glColor3f((float)0.35f, (float)0.35f, (float)0.35f);
            this.field_146297_k.field_71466_p.func_78276_b(text, this.getScreenX() + this.getGuiSizeX() + 4, this.getScreenY() + sizeY / 2 - 3 + this.rightTabOffset, 0x555555);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
        this.rightTabOffset += sizeY + 2;
    }

    private void addLeftInfoText(String text, int sizeY) {
        int width = this.field_146297_k.field_71466_p.func_78256_a(text) + 6;
        GuiHelper.bindGuiTextures();
        GuiHelper.drawCappedRect(this.getScreenX() - width, this.getScreenY() + this.leftTabOffset, 0, 116, 2, width, sizeY, 255, 22);
        if (!text.isEmpty()) {
            GlStateManager.func_179094_E();
            GL11.glColor3f((float)0.35f, (float)0.35f, (float)0.35f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)5.0f);
            this.field_146297_k.field_71466_p.func_78276_b(text, this.getScreenX() - width + 4, this.getScreenY() + sizeY / 2 - 3 + this.leftTabOffset, 0x555555);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
        this.leftTabOffset += sizeY + 2;
    }

    private void addGraphicsBeforeRendering() {
        GuiHelper.bindGuiTextures();
        if (this.te != null) {
            if (this.te instanceof TileEntityUpgradable) {
                this.addUpgradeSlot(0);
                this.addUpgradeSlot(1);
            }
            if (this.te instanceof IProgress) {
                this.addProgressBar(((IProgress)((Object)this.te)).getCurrentProgress(), ((IProgress)((Object)this.te)).getMaxProgress());
            }
        }
    }

    private void addGraphicsAfterRendering(int mouseX, int mouseY) {
        GlStateManager.func_179140_f();
        GuiHelper.bindGuiTextures();
        if (this.te != null) {
            if (this.te instanceof ISecurity) {
                String name = ((ISecurity)((Object)this.te)).getSecurityProfile().getOwnerName();
                int width = this.field_146297_k.field_71466_p.func_78256_a(name) + 5;
                GuiHelper.drawCappedRect(this.getScreenX() + this.getGuiSizeX() / 2 - width / 2, this.getScreenY() + this.getGuiSizeY(), 0, 116, 0, width, 13, 256, 22);
                GuiHelper.drawCenteredString(name, this.getScreenX() + this.getGuiSizeX() / 2, this.getScreenY() + this.getGuiSizeY() + 3, 0x555555);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (this.te instanceof ICurrencyNetworkBank) {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                this.addCurrencyInfo(mouseX, mouseY, ((ICurrencyNetworkBank)((Object)this.te)).getStoredCurrency(), ((ICurrencyNetworkBank)((Object)this.te)).getMaxCurrency());
            }
            if (this.te instanceof IProgress) {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                this.addProgressBarText(mouseX, mouseY, ((IProgress)((Object)this.te)).getCurrentProgress(), ((IProgress)((Object)this.te)).getMaxProgress());
            }
        }
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        this.leftTabOffset = 4;
        this.rightTabOffset = 4;
        this.func_73876_c();
        GuiHelper.bindTexture(this.getGuiTextureName());
        GuiHelper.drawRect(this.getScreenX(), this.getScreenY(), 0, 0, 0, this.getGuiSizeX(), this.getGuiSizeY());
        this.drawGuiBackground(mouseX, mouseY);
        GlStateManager.func_179119_h();
        GuiHelper.drawCenteredString(this.getGuiTitle(), this.getScreenX() + this.getGuiSizeX() / 2, this.getScreenY() + 6, 0x555555);
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        this.func_146276_q_();
        this.addGraphicsBeforeRendering();
        super.func_73863_a(mouseX, mouseY, f);
        this.addGraphicsAfterRendering(mouseX, mouseY);
        this.drawGuiForeground(mouseX, mouseY);
        this.func_191948_b(mouseX, mouseY);
    }
}

