/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.gui.base;

import calemiutils.CUReference;
import calemiutils.gui.base.GuiInteractionButton;
import calemiutils.gui.base.GuiRect;
import calemiutils.item.ItemInteractionInterfaceFilter;
import calemiutils.tileentity.TileEntityInteractionInterface;
import calemiutils.util.Location;
import calemiutils.util.helper.GuiHelper;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class GuiInteractionTab {
    private final List<GuiButton> buttonList;
    private final RenderItem itemRender;
    public ItemStack filter = ItemStack.field_190927_a;
    private final ItemStack icon;
    public final String name;
    private final String tooltip;
    public final List<GuiInteractionButton> buttons;
    public int x;
    private final int y;
    private final int buttonX;
    public final GuiRect rect;

    public GuiInteractionTab(List<GuiButton> buttonList, RenderItem itemRender, ItemStack icon, String name, String tooltip, int x, int y, int buttonX) {
        this.buttonList = buttonList;
        this.itemRender = itemRender;
        this.icon = icon;
        this.name = name;
        this.tooltip = tooltip;
        this.buttons = new ArrayList<GuiInteractionButton>();
        this.x = x;
        this.y = y;
        this.buttonX = buttonX;
        this.rect = new GuiRect(x, y, 16, 16);
    }

    public GuiInteractionTab(List<GuiButton> buttonList, RenderItem itemRender, ItemStack filter, int x, int y, int buttonX) {
        this(buttonList, itemRender, ItemInteractionInterfaceFilter.getFilterIcon(filter), ItemInteractionInterfaceFilter.getFilterName(filter), ItemInteractionInterfaceFilter.getFilterTooltip(filter), x, y, buttonX);
        this.filter = filter;
    }

    public List<Location> getLocations() {
        ArrayList<Location> list = new ArrayList<Location>();
        for (GuiInteractionButton button : this.buttons) {
            list.add(button.location);
        }
        return list;
    }

    public void addButton(int id, TileEntityInteractionInterface teII, Location location, EntityPlayer player) {
        if (this.buttons.size() < 63) {
            IInventory inv = location.getIInventory();
            if (inv != null && !inv.func_70300_a(player)) {
                return;
            }
            ItemStack stack = new ItemStack(location.getBlock());
            GuiInteractionButton button = new GuiInteractionButton(id, this.x, this.y, this.itemRender, teII, location, stack, this.buttonList);
            button.field_146124_l = false;
            this.buttons.add(button);
        }
    }

    public void enableButtons(boolean value) {
        for (GuiInteractionButton button : this.buttons) {
            button.field_146124_l = value;
        }
    }

    public void renderTab(int mouseX, int mouseY) {
        String[] strings = new String[]{this.name};
        if (!this.tooltip.isEmpty()) {
            strings = new String[]{this.name, "", ChatFormatting.ITALIC + this.tooltip};
        }
        GuiHelper.drawItemStack(this.itemRender, this.icon, this.rect.x, this.rect.y);
        GuiHelper.drawHoveringTextBox(mouseX, mouseY, 150, this.rect, strings);
    }

    public void renderSelectedTab() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(CUReference.GUI_TEXTURES);
        GuiHelper.drawRect(this.x, this.y + 18, 0, 0, 10, 16, 1);
    }

    public void renderButtons() {
        int count = 0;
        for (GuiInteractionButton button : this.buttons) {
            if (!button.field_146124_l) continue;
            int yOffset = 34;
            int rowSize = 9;
            int xPos = this.buttonX + count % rowSize * 18;
            int yPos = this.y + yOffset + count / rowSize * 18;
            int size = 16;
            button.rect = new GuiRect(xPos, yPos, size, size);
            button.field_146128_h = xPos;
            button.field_146129_i = yPos;
            ++count;
        }
    }
}

