/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.gui.base;

import calemiutils.CUReference;
import calemiutils.config.MarketItemsFile;
import calemiutils.gui.base.GuiMarketButton;
import calemiutils.gui.base.GuiRect;
import calemiutils.util.helper.GuiHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.ItemStack;

public class GuiMarketTab {
    private final List<GuiButton> buttonList;
    private final RenderItem itemRender;
    public ItemStack filter = ItemStack.field_190927_a;
    private final String name;
    public final List<GuiMarketButton> buttons;
    private final int buttonX;
    public final GuiRect rect;

    public GuiMarketTab(List<GuiButton> buttonList, RenderItem itemRender, String name, int x, int y, int buttonX) {
        this.buttonList = buttonList;
        this.itemRender = itemRender;
        this.name = name;
        this.buttons = new ArrayList<GuiMarketButton>();
        this.buttonX = buttonX;
        this.rect = new GuiRect(x - 24, y, 48, 16);
    }

    public void addButton(int id, MarketItemsFile.MarketItem marketItem) {
        if (this.buttons.size() < 63) {
            GuiMarketButton button = new GuiMarketButton(id, this.rect.x, this.rect.y, this.itemRender, marketItem, this.buttonList);
            button.field_146124_l = false;
            this.buttons.add(button);
        }
    }

    public void renderButtons() {
        int count = 0;
        for (GuiMarketButton button : this.buttons) {
            if (!button.field_146124_l) continue;
            int yOffset = 15;
            int rowSize = 9;
            int xPos = this.buttonX + count % rowSize * 18;
            int yPos = this.rect.y + yOffset + count / rowSize * 18;
            int size = 16;
            button.rect = new GuiRect(xPos, yPos, size, size);
            button.field_146128_h = xPos;
            button.field_146129_i = yPos;
            ++count;
        }
    }

    public void enableButtons(boolean value) {
        for (GuiMarketButton button : this.buttons) {
            button.field_146124_l = value;
        }
    }

    public void renderTab() {
        GuiHelper.drawCenteredString(this.name, this.rect.x + this.rect.width / 2, this.rect.y, 0xFFFFFF);
    }

    public void renderSelectedTab() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(CUReference.GUI_TEXTURES);
        GuiHelper.drawRect(this.rect.x, this.rect.y + 9, 0, 0, 100, this.rect.width - 1, 1);
    }
}

