/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.inventory;

import calemiutils.inventory.base.ContainerBase;
import calemiutils.inventory.base.ItemStackInventory;
import calemiutils.item.ItemBuildersKit;
import calemiutils.util.helper.ItemHelper;
import calemiutils.util.helper.NBTHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ContainerBuildersKit
extends ContainerBase {
    private final EntityPlayer player;
    private final ItemStack stack;
    private final ItemStackInventory stackInv;

    public ContainerBuildersKit(EntityPlayer player) {
        super(player, 1);
        this.isItemContainer = true;
        this.player = player;
        this.stack = player.func_184614_ca();
        this.stackInv = new ItemStackInventory(this.stack, this.size);
        this.addPlayerInv(8, 94);
        this.addPlayerHotbar(8, 152);
        this.func_75146_a(new Slot((IInventory)this.stackInv, 0, 80, 50));
    }

    private ItemStack getHeldStack() {
        ItemStack heldStack = this.player.func_184614_ca();
        if (!heldStack.func_190926_b() && heldStack.func_77973_b() instanceof ItemBuildersKit) {
            return heldStack;
        }
        return null;
    }

    private ItemBuildersKit getKit() {
        if (this.getHeldStack() == null) {
            return null;
        }
        return (ItemBuildersKit)this.getHeldStack().func_77973_b();
    }

    private NBTTagCompound getNBT() {
        if (this.getHeldStack() != null) {
            return ItemHelper.getNBT(this.player.func_184614_ca());
        }
        return null;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        NBTTagCompound nbt;
        ItemStack returnStack = super.func_184996_a(slotId, dragType, clickTypeIn, player);
        if (this.getHeldStack() != null && (nbt = this.getNBT()) != null) {
            ItemStack stack = this.stackInv.func_70301_a(0);
            ItemStack stackFilter = NBTHelper.loadItem(nbt, 0);
            int amount = ItemBuildersKit.getAmountOfBlocks(this.getHeldStack());
            if (stack != null && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlock) {
                if (amount == 0 && !stack.func_190926_b()) {
                    NBTHelper.saveItem(this.getNBT(), stack, 0);
                    this.addAmount(stack);
                } else if (stack.func_77969_a(stackFilter)) {
                    this.addAmount(stack);
                }
            }
        }
        return returnStack;
    }

    private void addAmount(ItemStack stack) {
        int amountAdded = ItemBuildersKit.addAmountOfBlocks(this.getHeldStack(), stack.func_190916_E());
        this.stackInv.func_70298_a(0, amountAdded);
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        this.stackInv.dump(this.stack);
    }
}

