/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.inventory;

import calemiutils.config.CUConfig;
import calemiutils.init.InitItems;
import calemiutils.inventory.base.ContainerBase;
import calemiutils.inventory.base.ItemStackInventory;
import calemiutils.inventory.base.SlotFilter;
import calemiutils.item.ItemCurrency;
import calemiutils.util.helper.CurrencyHelper;
import calemiutils.util.helper.ItemHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ContainerWallet
extends ContainerBase {
    private final EntityPlayer player;
    private final ItemStack stack;
    private final ItemStackInventory stackInv;

    public ContainerWallet(EntityPlayer player) {
        super(player, 1);
        this.isItemContainer = true;
        this.player = player;
        this.stack = player.func_184614_ca();
        this.stackInv = new ItemStackInventory(this.stack, this.size);
        this.addPlayerInv(8, 94);
        this.addPlayerHotbar(8, 152);
        this.func_75146_a(new SlotFilter(this.stackInv, 0, 17, 42, InitItems.COIN_PENNY, InitItems.COIN_NICKEL, InitItems.COIN_QUARTER, InitItems.COIN_DOLLAR));
    }

    private ItemStack getCurrentWalletStack() {
        return CurrencyHelper.getCurrentWalletStack(this.player, false);
    }

    private NBTTagCompound getNBT() {
        return ItemHelper.getNBT(this.getCurrentWalletStack());
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        ItemStack returnStack = super.func_184996_a(slotId, dragType, clickTypeIn, player);
        ItemStack stack = this.stackInv.func_70301_a(0);
        if (stack != null && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemCurrency) {
            ItemCurrency currency = (ItemCurrency)stack.func_77973_b();
            int balance = this.getNBT().func_74762_e("balance");
            int amountToAdd = 0;
            int stacksToRemove = 0;
            for (int i = 0; i < stack.func_190916_E(); ++i) {
                if (balance + currency.value > CUConfig.wallet.walletCurrencyCapacity) continue;
                balance += currency.value;
                amountToAdd += currency.value;
                ++stacksToRemove;
            }
            this.getNBT().func_74768_a("balance", this.getNBT().func_74762_e("balance") + amountToAdd);
            this.stackInv.func_70298_a(0, stacksToRemove);
        }
        return returnStack;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        this.stackInv.dump(this.stack);
    }
}

