/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.inventory.base;

import calemiutils.tileentity.base.TileEntityInventoryBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerBase
extends Container {
    private final EntityPlayer player;
    protected TileEntityInventoryBase tileEntity;
    protected int size;
    protected boolean isItemContainer;

    protected ContainerBase(EntityPlayer player, TileEntityInventoryBase tileEntity) {
        this.player = player;
        this.tileEntity = tileEntity;
    }

    public ContainerBase(EntityPlayer player, TileEntityInventoryBase tileEntity, int x, int y) {
        this(player, tileEntity);
        this.addPlayerInv(x, y);
        this.addPlayerHotbar(x, y + 58);
    }

    protected ContainerBase(EntityPlayer player, int size) {
        this.player = player;
        this.size = size;
    }

    private int getTileEntitySlotAmount() {
        return this.isItemContainer ? this.size : this.tileEntity.func_70302_i_();
    }

    protected void addPlayerInv(int x, int y) {
        this.addStorageInv((IInventory)this.player.field_71071_by, 9, x, y, 3);
    }

    protected void addPlayerHotbar(int x, int y) {
        this.addStorageInv((IInventory)this.player.field_71071_by, 0, x, y, 1);
    }

    private void addStorageInv(IInventory inv, int idOffset, int x, int y, int height) {
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot(inv, j + i * 9 + idOffset, x + j * 18, y + i * 18));
            }
        }
    }

    protected void addTileEntityStorageInv(IInventory inv, int idOffset, int x, int y, int height) {
        int id = idOffset;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.tileEntity.containerSlots[id] = this.func_75146_a(new Slot(inv, id, x + j * 18, y + i * 18));
                ++id;
            }
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotId) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotId);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemStack1 = slot.func_75211_c();
            itemstack = itemStack1.func_77946_l();
            if (this.getTileEntitySlotAmount() > 0) {
                if (slotId <= 35) {
                    if (this.mergeIfPossible(slot, itemStack1, itemstack, 36, 36 + this.getTileEntitySlotAmount()) && this.mergeInvHotbarIfPossible(slot, itemStack1, itemstack, slotId)) {
                        return ItemStack.field_190927_a;
                    }
                } else {
                    if (this.mergeIfPossible(slot, itemStack1, itemstack, 0, 35)) {
                        return ItemStack.field_190927_a;
                    }
                    slot.func_75220_a(itemStack1, itemstack);
                }
            } else if (this.mergeInvHotbarIfPossible(slot, itemStack1, itemstack, slotId)) {
                return ItemStack.field_190927_a;
            }
            if (itemStack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemStack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemStack1);
        }
        return itemstack;
    }

    private boolean mergeIfPossible(Slot slot, ItemStack is, ItemStack is2, int id, int maxId) {
        if (!this.func_75135_a(is, id, maxId, false)) {
            return true;
        }
        slot.func_75220_a(is, is2);
        return false;
    }

    private boolean mergeInvHotbarIfPossible(Slot slot, ItemStack is, ItemStack is2, int id) {
        if (id < 27) {
            if (this.mergeIfPossible(slot, is, is2, 27, 35)) {
                return true;
            }
            slot.func_75220_a(is, is2);
        } else {
            if (this.mergeIfPossible(slot, is, is2, 0, 26)) {
                return true;
            }
            slot.func_75220_a(is, is2);
        }
        return false;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }
}

