/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.item;

import calemiutils.config.CUConfig;
import calemiutils.item.base.ItemBase;
import calemiutils.util.helper.InventoryHelper;
import calemiutils.util.helper.ItemHelper;
import calemiutils.util.helper.LoreHelper;
import calemiutils.util.helper.SoundHelper;
import calemiutils.util.helper.StringHelper;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.FoodStats;
import net.minecraft.world.World;

public class ItemBlender
extends ItemBase {
    public ItemBlender() {
        super("blender", 1);
        if (CUConfig.itemUtils.blender) {
            this.addItem();
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        LoreHelper.addDisabledLore(tooltip, CUConfig.misc.blenderMaxJuice);
        LoreHelper.addInformationLore(tooltip, "Blends up food into juice which you can drink!");
        LoreHelper.addControlsLore(tooltip, "Drink", LoreHelper.Type.USE);
        LoreHelper.addControlsLore(tooltip, "Toggle Processing Mode", LoreHelper.Type.SNEAK_USE, true);
        tooltip.add("");
        tooltip.add("Process Food: " + ChatFormatting.AQUA + (ItemHelper.getNBT(stack).func_74767_n("process") ? "ON" : "OFF"));
        tooltip.add("Juice: " + ChatFormatting.AQUA + StringHelper.printCommas((int)ItemHelper.getNBT(stack).func_74760_g("juice")) + " / " + StringHelper.printCommas(CUConfig.misc.blenderMaxJuice));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (ItemHelper.getNBT(stack).func_74767_n("process") && entityIn instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityIn;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack currentStack = player.field_71071_by.func_70301_a(i);
                if (currentStack.func_190926_b() || !(currentStack.func_77973_b() instanceof ItemFood)) continue;
                float food = ((ItemFood)currentStack.func_77973_b()).func_150905_g(currentStack) / 2;
                if (!(ItemHelper.getNBT(stack).func_74760_g("juice") + food <= (float)CUConfig.misc.blenderMaxJuice)) continue;
                InventoryHelper.consumeItem((IInventory)player.field_71071_by, 1, false, currentStack);
                ItemHelper.getNBT(stack).func_74776_a("juice", ItemHelper.getNBT(stack).func_74760_g("juice") + food);
            }
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        NBTTagCompound nbt = ItemHelper.getNBT(stack);
        FoodStats stats = ((EntityPlayer)entityLiving).func_71024_bL();
        float juice = nbt.func_74760_g("juice");
        int missingFood = 20 - stats.func_75116_a();
        int addedFood = 0;
        int addedSat = 0;
        if (juice >= 1.0f) {
            if (missingFood > 0) {
                ++addedFood;
                addedSat += 2;
            }
            this.decreaseJuice(nbt, 1.0f);
            stats.func_75122_a(addedFood, (float)addedSat);
        }
        return stack;
    }

    private void decreaseJuice(NBTTagCompound nbt, float amount) {
        nbt.func_74776_a("juice", nbt.func_74760_g("juice") - amount);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (playerIn.func_70093_af()) {
            ItemHelper.getNBT(itemstack).func_74757_a("process", !ItemHelper.getNBT(itemstack).func_74767_n("process"));
            SoundHelper.playClick(worldIn, playerIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        if (playerIn.func_71024_bL().func_75116_a() < 20) {
            playerIn.func_184598_c(handIn);
            new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
    }

    @Override
    public boolean func_77636_d(ItemStack stack) {
        return ItemHelper.getNBT(stack).func_74767_n("process");
    }

    public int func_77626_a(ItemStack stack) {
        return 16;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }
}

