/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.item;

import calemiutils.CalemiUtils;
import calemiutils.config.CUConfig;
import calemiutils.item.base.ItemBase;
import calemiutils.util.Location;
import calemiutils.util.helper.InventoryHelper;
import calemiutils.util.helper.ItemHelper;
import calemiutils.util.helper.LoreHelper;
import calemiutils.util.helper.NBTHelper;
import calemiutils.util.helper.SoundHelper;
import calemiutils.util.helper.StringHelper;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemBuildersKit
extends ItemBase {
    public ItemBuildersKit() {
        super("builders_kit", 1);
        if (CUConfig.itemUtils.buildersKit) {
            this.addItem();
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        LoreHelper.addDisabledLore(tooltip, CUConfig.misc.buildersKitCapacity);
        LoreHelper.addInformationLore(tooltip, "Stores huge amounts of the same block type that can be placed! Can also be used on Blueprints!");
        LoreHelper.addControlsLore(tooltip, "Place Block", LoreHelper.Type.USE, true);
        LoreHelper.addControlsLore(tooltip, "Open Inventory", LoreHelper.Type.SNEAK_USE);
        LoreHelper.addControlsLore(tooltip, "Place the blocks stored into the Blueprints", LoreHelper.Type.LEFT_CLICK_BLUEPRINT);
        tooltip.add("");
        tooltip.add("Block: " + ChatFormatting.AQUA + this.getBlockName(stack));
        tooltip.add("Amount: " + ChatFormatting.AQUA + StringHelper.printCommas(ItemBuildersKit.getAmountOfBlocks(stack)) + " / " + StringHelper.printCommas(CUConfig.misc.buildersKitCapacity));
        tooltip.add("Suck: " + ChatFormatting.AQUA + (ItemHelper.getNBT(stack).func_74767_n("suck") ? "ON" : "OFF"));
    }

    public String getBlockName(ItemStack stack) {
        String name = "Not set";
        ItemStack stackFilter = ((ItemBuildersKit)stack.func_77973_b()).getBlockType(stack);
        if (stackFilter != null && !stackFilter.func_190926_b()) {
            name = stackFilter.func_82833_r();
        }
        return name;
    }

    public ItemStack getBlockType(ItemStack stack) {
        return NBTHelper.loadItem(ItemHelper.getNBT(stack), 0);
    }

    public static int getAmountOfBlocks(ItemStack stack) {
        NBTTagCompound nbt = ItemHelper.getNBT(stack);
        if (nbt == null) {
            return 0;
        }
        return nbt.func_74762_e("amount");
    }

    public static void setAmountOfBlocks(ItemStack stack, int amount) {
        ItemHelper.getNBT(stack).func_74768_a("amount", amount);
    }

    public static int addAmountOfBlocks(ItemStack stack, int amount) {
        int amountToSet = ItemBuildersKit.getAmountOfBlocks(stack) + amount;
        int amountAdded = amount;
        if (amountToSet > CUConfig.misc.buildersKitCapacity) {
            amountToSet = CUConfig.misc.buildersKitCapacity;
            amountAdded = CUConfig.misc.buildersKitCapacity - ItemBuildersKit.getAmountOfBlocks(stack);
        }
        ItemBuildersKit.setAmountOfBlocks(stack, amountToSet);
        return amountAdded;
    }

    public void toggleSuck(ItemStack stack) {
        ItemHelper.getNBT(stack).func_74757_a("suck", !ItemHelper.getNBT(stack).func_74767_n("suck"));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldStack;
        if (!player.func_70093_af() && !(heldStack = player.func_184614_ca()).func_190926_b()) {
            Location hit = new Location(worldIn, pos);
            ItemStack filterStack = this.getBlockType(heldStack);
            if (!hit.getBlock().func_149688_o(hit.getBlockState()).func_76222_j()) {
                hit = new Location(hit, facing);
            }
            if (filterStack != null && filterStack.func_77973_b() instanceof ItemBlock) {
                ItemBlock itemBlock = (ItemBlock)filterStack.func_77973_b();
                Location playerLoc = new Location(player.field_70170_p, (int)Math.floor(player.field_70165_t), (int)Math.floor(player.field_70163_u), (int)Math.floor(player.field_70161_v));
                if (ItemBuildersKit.getAmountOfBlocks(heldStack) > 0 && itemBlock.func_179223_d().func_176198_a(worldIn, hit.getBlockPos(), facing) && !playerLoc.equals(hit) && !new Location(playerLoc, EnumFacing.UP).equals(hit)) {
                    IBlockState state = Block.func_149634_a((Item)filterStack.func_77973_b()).getStateForPlacement(player.field_70170_p, hit.getBlockPos(), facing, 0.0f, 0.0f, 0.0f, filterStack.func_77952_i(), (EntityLivingBase)player, EnumHand.MAIN_HAND);
                    hit.setBlock(state, player);
                    ItemBuildersKit.setAmountOfBlocks(heldStack, ItemBuildersKit.getAmountOfBlocks(heldStack) - 1);
                    SoundHelper.playBlockPlaceSound(player.field_70170_p, player, itemBlock.func_179223_d().func_176223_P(), hit);
                    return EnumActionResult.SUCCESS;
                }
            }
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!worldIn.field_72995_K && CUConfig.misc.buildersKitCapacity > 0 && playerIn != null && !playerIn.func_184614_ca().func_190926_b() && playerIn.func_70093_af()) {
            playerIn.openGui((Object)CalemiUtils.instance, 65, worldIn, (int)playerIn.field_70165_t, (int)playerIn.field_70163_u, (int)playerIn.field_70161_v);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (entityIn.field_70170_p.func_72820_D() % 2L == 0L && entityIn instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityIn;
            if (ItemHelper.getNBT(stack).func_74767_n("suck") && this.getBlockType(stack) != null) {
                int count = InventoryHelper.countItems((IInventory)player.field_71071_by, false, false, this.getBlockType(stack));
                if (count > 64) {
                    count = 64;
                }
                if (count > 0) {
                    InventoryHelper.consumeItem((IInventory)player.field_71071_by, ItemBuildersKit.addAmountOfBlocks(stack, count), false, this.getBlockType(stack));
                }
            }
        }
    }

    @Override
    public boolean func_77636_d(ItemStack stack) {
        return ItemHelper.getNBT(stack).func_74767_n("suck");
    }
}

