/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.item;

import calemiutils.block.BlockBlueprint;
import calemiutils.config.CUConfig;
import calemiutils.item.base.ItemBase;
import calemiutils.util.Location;
import calemiutils.util.VeinScan;
import calemiutils.util.helper.LoreHelper;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemEraser
extends ItemBase {
    public ItemEraser() {
        super("eraser", 1);
        if (CUConfig.itemUtils.eraser && CUConfig.blockUtils.blueprint) {
            this.addItem();
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        LoreHelper.addInformationLore(tooltip, "Destroys blueprint.");
        LoreHelper.addControlsLore(tooltip, "Erases one blueprint", LoreHelper.Type.USE, true);
        LoreHelper.addControlsLore(tooltip, "Erases all connected blueprints", LoreHelper.Type.SNEAK_USE);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (state.func_177230_c() instanceof BlockBlueprint) {
            return 9.0f;
        }
        return super.func_150893_a(stack, state);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Location location = new Location(worldIn, pos);
        if (location.getBlock() instanceof BlockBlueprint) {
            if (!player.func_70093_af()) {
                location.setBlockToAir();
            } else {
                VeinScan scan = new VeinScan(location, location.getBlockState());
                scan.startScan();
                for (Location nextLocation : scan.buffer) {
                    nextLocation.setBlockToAir();
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }
}

