/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.item;

import calemiutils.CalemiUtils;
import calemiutils.config.CUConfig;
import calemiutils.item.base.ItemBase;
import calemiutils.tileentity.TileEntityInteractionInterface;
import calemiutils.util.Location;
import calemiutils.util.helper.ItemHelper;
import calemiutils.util.helper.LoreHelper;
import calemiutils.util.helper.NBTHelper;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemInteractionInterfaceFilter
extends ItemBase {
    public ItemInteractionInterfaceFilter() {
        super("interaction_interface_filter", 1);
        if (CUConfig.blockUtils.interactionNetwork) {
            this.addItem();
        }
    }

    public static boolean isValidFilter(ItemStack stack) {
        return !ItemInteractionInterfaceFilter.getFilterIcon(stack).func_190926_b() && !ItemInteractionInterfaceFilter.getFilterName(stack).isEmpty();
    }

    public static ItemStack getFilterIcon(ItemStack stack) {
        NBTTagCompound nbt = ItemHelper.getNBT(stack);
        return NBTHelper.loadItem(nbt, 0);
    }

    public static void setFilterIcon(ItemStack stack, ItemStack filterStack) {
        NBTTagCompound nbt = ItemHelper.getNBT(stack);
        NBTHelper.saveItem(nbt, filterStack, 0);
    }

    public static String getFilterName(ItemStack stack) {
        NBTTagCompound nbt = ItemHelper.getNBT(stack);
        if (nbt.func_74764_b("filterName")) {
            return nbt.func_74779_i("filterName");
        }
        return "";
    }

    public static void setFilterName(ItemStack stack, String string) {
        NBTTagCompound nbt = ItemHelper.getNBT(stack);
        nbt.func_74778_a("filterName", string);
    }

    public static String getFilterTooltip(ItemStack stack) {
        NBTTagCompound nbt = ItemHelper.getNBT(stack);
        if (nbt.func_74764_b("filterTooltip")) {
            return nbt.func_74779_i("filterTooltip");
        }
        return "";
    }

    public static void setFilterTooltip(ItemStack stack, String string) {
        NBTTagCompound nbt = ItemHelper.getNBT(stack);
        nbt.func_74778_a("filterTooltip", string);
    }

    public static boolean isSameFilter(ItemStack stack1, ItemStack stack2) {
        if (ItemStack.func_77989_b((ItemStack)ItemInteractionInterfaceFilter.getFilterIcon(stack1), (ItemStack)ItemInteractionInterfaceFilter.getFilterIcon(stack2))) {
            return ItemInteractionInterfaceFilter.getFilterName(stack1).equalsIgnoreCase(ItemInteractionInterfaceFilter.getFilterName(stack2)) && ItemInteractionInterfaceFilter.getFilterTooltip(stack1).equalsIgnoreCase(ItemInteractionInterfaceFilter.getFilterTooltip(stack2));
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        LoreHelper.addInformationLore(tooltip, "Placed in Interaction Interfaces. Used to add custom tabs inside the Interaction Terminal to sort your buttons.");
        LoreHelper.addControlsLore(tooltip, "Open Inventory", LoreHelper.Type.USE, true);
        tooltip.add("");
        tooltip.add("Filter Icon: " + ChatFormatting.AQUA + (ItemInteractionInterfaceFilter.getFilterIcon(stack).func_190926_b() ? "Not set" : ItemInteractionInterfaceFilter.getFilterIcon(stack).func_82833_r()));
        tooltip.add("Filter Name: " + ChatFormatting.AQUA + (ItemInteractionInterfaceFilter.getFilterName(stack).isEmpty() ? "Not set" : ItemInteractionInterfaceFilter.getFilterName(stack)));
        tooltip.add("Filter Tooltip: " + ChatFormatting.AQUA + (ItemInteractionInterfaceFilter.getFilterTooltip(stack).isEmpty() ? "Not set" : ItemInteractionInterfaceFilter.getFilterTooltip(stack)));
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        Location location = new Location(world, pos);
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemInteractionInterfaceFilter && location.getTileEntity() != null && location.getTileEntity() instanceof TileEntityInteractionInterface && location.getIInventory() != null) {
            TileEntityInteractionInterface teInterface = (TileEntityInteractionInterface)location.getTileEntity();
            teInterface.tabIconStack = heldItem;
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!worldIn.field_72995_K && playerIn != null && !playerIn.func_184614_ca().func_190926_b()) {
            playerIn.openGui((Object)CalemiUtils.instance, 66, worldIn, (int)playerIn.field_70165_t, (int)playerIn.field_70163_u, (int)playerIn.field_70161_v);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }
}

