/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.item;

import calemiutils.CalemiUtils;
import calemiutils.config.CUConfig;
import calemiutils.gui.GuiLinkBook;
import calemiutils.item.base.ItemBase;
import calemiutils.tileentity.TileEntityBookStand;
import calemiutils.tileentity.base.TileEntityBase;
import calemiutils.util.Location;
import calemiutils.util.UnitChatMessage;
import calemiutils.util.helper.EntityHelper;
import calemiutils.util.helper.InventoryHelper;
import calemiutils.util.helper.ItemHelper;
import calemiutils.util.helper.LoreHelper;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLinkBookLocation
extends ItemBase {
    public ItemLinkBookLocation() {
        super("link_book_location", 1);
        this.func_77637_a(CalemiUtils.TAB);
        if (CUConfig.itemUtils.locationLinkBook) {
            this.addItem();
        }
    }

    private static UnitChatMessage getUnitChatMessage(EntityPlayer player) {
        return new UnitChatMessage("Location Link Book", player);
    }

    public static Location getLinkedLocation(World world, ItemStack is) {
        NBTTagCompound nbt = ItemHelper.getNBT(is);
        if (nbt.func_74764_b("X") && nbt.func_74764_b("Y") && nbt.func_74764_b("Z")) {
            return new Location(world, nbt.func_74762_e("X"), nbt.func_74762_e("Y"), nbt.func_74762_e("Z"));
        }
        return null;
    }

    public static int getLinkedDimension(ItemStack is) {
        NBTTagCompound nbt = ItemHelper.getNBT(is);
        if (nbt.func_74764_b("Dim")) {
            return nbt.func_74762_e("Dim");
        }
        return 0;
    }

    public static void bindName(ItemStack is, String name) {
        if (!name.isEmpty()) {
            is.func_151001_c(name);
        } else {
            is.func_135074_t();
        }
    }

    public static void bindLocation(ItemStack is, EntityPlayer player, Location location, boolean printMessage) {
        ItemHelper.getNBT(is).func_74757_a("linked", true);
        NBTTagCompound nbt = ItemHelper.getNBT(is);
        nbt.func_74768_a("X", location.x);
        nbt.func_74768_a("Y", location.y);
        nbt.func_74768_a("Z", location.z);
        nbt.func_74768_a("Dim", player.field_70170_p.field_73011_w.getDimension());
        nbt.func_74778_a("DimName", player.field_70170_p.field_73011_w.func_186058_p().name());
        if (!player.field_70170_p.field_72995_K && printMessage) {
            ItemLinkBookLocation.getUnitChatMessage(player).printMessage(TextFormatting.GREEN, "Linked location to " + location.toString());
        }
    }

    public static void resetLocation(ItemStack is, EntityPlayer player) {
        ItemHelper.getNBT(is).func_74757_a("linked", false);
        NBTTagCompound nbt = ItemHelper.getNBT(is);
        nbt.func_82580_o("X");
        nbt.func_82580_o("Y");
        nbt.func_82580_o("Z");
        nbt.func_82580_o("Dim");
        nbt.func_82580_o("DimName");
        if (!player.field_70170_p.field_72995_K) {
            ItemLinkBookLocation.getUnitChatMessage(player).printMessage(TextFormatting.GREEN, "Cleared Book");
        }
    }

    public static void teleport(World world, EntityPlayer player, Location location, int dim) {
        if (!world.field_72995_K) {
            EntityHelper.teleportPlayer((EntityPlayerMP)player, location, dim);
            ItemLinkBookLocation.getUnitChatMessage(player).printMessage(TextFormatting.GREEN, "Teleported you to " + location.toString());
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound nbt = ItemHelper.getNBT(stack);
        Location location = ItemLinkBookLocation.getLinkedLocation(worldIn, stack);
        LoreHelper.addInformationLore(tooltip, "Creates a link to teleport to.");
        LoreHelper.addControlsLore(tooltip, "Open Gui", LoreHelper.Type.USE, true);
        tooltip.add("");
        String locationStr = "Not set";
        if (location != null) {
            locationStr = location.x + ", " + location.y + ", " + location.z;
        }
        tooltip.add("[Location] " + ChatFormatting.AQUA + locationStr);
        tooltip.add("[Dimension] " + ChatFormatting.AQUA + (nbt.func_74764_b("DimName") ? nbt.func_74779_i("DimName") : "Not set"));
    }

    public boolean isLinked(ItemStack stack) {
        return ItemHelper.getNBT(stack).func_74767_n("linked");
    }

    @Override
    public boolean func_77636_d(ItemStack stack) {
        return this.isLinked(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack heldItem = playerIn.func_184614_ca();
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemLinkBookLocation && worldIn.field_72995_K) {
            this.openGui(playerIn, heldItem);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)playerIn.func_184586_b(handIn));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Location location = new Location(worldIn, pos);
        ItemStack heldItem = player.func_184614_ca();
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemLinkBookLocation && location.getTileEntity() != null && location.getTileEntity() instanceof TileEntityBookStand && location.getIInventory() != null) {
            if (InventoryHelper.insertHeldItemIntoSlot(player, hand, location, location.getIInventory(), 0, true)) {
                ((TileEntityBase)location.getTileEntity()).markForUpdate();
                return EnumActionResult.SUCCESS;
            }
            ItemStack bookInventory = ((IInventory)location.getTileEntity()).func_70301_a(0);
            Location linkedLocation = ItemLinkBookLocation.getLinkedLocation(worldIn, bookInventory);
            if (!bookInventory.func_190926_b() && linkedLocation != null) {
                ItemLinkBookLocation.bindLocation(heldItem, player, linkedLocation, false);
                if (bookInventory.func_82837_s()) {
                    ItemLinkBookLocation.bindName(heldItem, bookInventory.func_82833_r());
                }
                if (!worldIn.field_72995_K) {
                    ItemLinkBookLocation.getUnitChatMessage(player).printMessage(TextFormatting.GREEN, "Copied Data from Book Stand");
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public void openGui(EntityPlayer player, ItemStack stack) {
        FMLClientHandler.instance().displayGuiScreen(player, (GuiScreen)new GuiLinkBook(player, stack));
    }
}

