/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.item;

import calemiutils.block.BlockBlueprint;
import calemiutils.config.CUConfig;
import calemiutils.gui.GuiPencil;
import calemiutils.init.InitBlocks;
import calemiutils.item.base.ItemBase;
import calemiutils.util.Location;
import calemiutils.util.helper.ItemHelper;
import calemiutils.util.helper.LoreHelper;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPencil
extends ItemBase {
    public ItemPencil() {
        super("pencil", 1);
        if (CUConfig.itemUtils.pencil && CUConfig.blockUtils.blueprint) {
            this.addItem();
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        LoreHelper.addInformationLore(tooltip, "Places Blueprint. Blueprint can be used for mass building!");
        LoreHelper.addControlsLore(tooltip, "Place Blueprint", LoreHelper.Type.USE, true);
        LoreHelper.addControlsLore(tooltip, "Change Blueprint Color", LoreHelper.Type.SNEAK_USE);
        tooltip.add("");
        tooltip.add("Color: " + ChatFormatting.AQUA + EnumDyeColor.func_176764_b((int)this.getColorMeta(stack)).func_192396_c().toUpperCase());
    }

    public int getColorMeta(ItemStack stack) {
        int meta = 11;
        if (ItemHelper.getNBT(stack).func_74764_b("color")) {
            meta = ItemHelper.getNBT(stack).func_74762_e("color");
        }
        return meta;
    }

    public void setColorByMeta(ItemStack stack, int meta) {
        ItemHelper.getNBT(stack).func_74768_a("color", meta);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        BlockBlueprint BLUEPRINT = (BlockBlueprint)InitBlocks.BLUEPRINT;
        Location location = new Location(worldIn, pos);
        if (player.func_70093_af()) {
            return EnumActionResult.FAIL;
        }
        if (!location.getBlock().func_149688_o(location.getBlockState()).func_76222_j() && !(location = new Location(location, facing)).isBlockValidForPlacing(InitBlocks.BLUEPRINT)) {
            return EnumActionResult.FAIL;
        }
        if (!player.func_175151_a(pos, facing, player.func_184586_b(hand))) {
            return EnumActionResult.FAIL;
        }
        if (location.isBlockValidForPlacing(InitBlocks.BLUEPRINT)) {
            location.setBlock(BLUEPRINT.func_176203_a(this.getColorMeta(player.func_184586_b(hand))));
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184614_ca();
        if (worldIn.field_72995_K && playerIn.func_70093_af() && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemPencil) {
            this.openGui(playerIn, stack);
            return new ActionResult(EnumActionResult.FAIL, (Object)playerIn.func_184586_b(handIn));
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)playerIn.func_184586_b(handIn));
    }

    @SideOnly(value=Side.CLIENT)
    private void openGui(EntityPlayer player, ItemStack stack) {
        FMLClientHandler.instance().displayGuiScreen(player, (GuiScreen)new GuiPencil(player, stack));
    }
}

