/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.item;

import calemiutils.config.CUConfig;
import calemiutils.event.WrenchEvent;
import calemiutils.item.base.ItemBase;
import calemiutils.security.ISecurity;
import calemiutils.tileentity.base.TileEntityBase;
import calemiutils.util.Location;
import calemiutils.util.helper.LoreHelper;
import calemiutils.util.helper.SecurityHelper;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemSecurityWrench
extends ItemBase {
    public ItemSecurityWrench() {
        super("security_wrench", 1);
        if (CUConfig.itemUtils.securityWrench) {
            this.addItem();
        }
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        Location location = new Location(world, pos);
        if (player.func_70093_af() && location.getTileEntity() != null && location.getTileEntity() instanceof TileEntityBase) {
            if (location.getTileEntity() instanceof ISecurity) {
                ISecurity security = (ISecurity)location.getTileEntity();
                if (security.getSecurityProfile().isOwner(player.func_70005_c_()) || player.field_71075_bZ.field_75098_d || !CUConfig.misc.useSecurity) {
                    WrenchEvent.onBlockWrenched(world, location);
                    return EnumActionResult.SUCCESS;
                }
                SecurityHelper.printErrorMessage(location, player);
            } else {
                WrenchEvent.onBlockWrenched(world, location);
            }
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        LoreHelper.addInformationLore(tooltip, "Used to access secured blocks!");
        LoreHelper.addControlsLore(tooltip, "Interact with secured blocks", LoreHelper.Type.USE, true);
        LoreHelper.addControlsLore(tooltip, "Pick up secured blocks", LoreHelper.Type.SNEAK_USE);
    }
}

