/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.item;

import calemiutils.CalemiUtils;
import calemiutils.init.InitEnchantments;
import calemiutils.init.InitItems;
import calemiutils.registry.IHasModel;
import calemiutils.util.Location;
import calemiutils.util.VeinScan;
import calemiutils.util.helper.LoreHelper;
import calemiutils.util.helper.WorldEditHelper;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemSledgehammer
extends ItemPickaxe
implements IHasModel {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150362_t, Blocks.field_150361_u, Blocks.field_150462_ai, Blocks.field_150435_aG, Blocks.field_150346_d, Blocks.field_150458_ak, Blocks.field_150349_c, Blocks.field_150351_n, Blocks.field_150391_bh, Blocks.field_150354_m, Blocks.field_150433_aE, Blocks.field_150431_aC, Blocks.field_150425_aM, Blocks.field_185774_da, Blocks.field_192444_dS, Blocks.field_150344_f, Blocks.field_150342_X, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_150428_aP, Blocks.field_150440_ba, Blocks.field_150468_ap, Blocks.field_150471_bO, Blocks.field_150452_aw});
    private double attackSpeed;
    private double attackDamage;
    public int chargeTime;

    public ItemSledgehammer(String name, Item.ToolMaterial toolMaterial, double attackSpeed, int chargeTime, boolean shouldRegister) {
        super(toolMaterial);
        String realName = "sledgehammer_" + name;
        this.func_77655_b(realName);
        this.setRegistryName(realName);
        this.func_77637_a(CalemiUtils.TAB);
        if (shouldRegister) {
            InitItems.ITEMS.add((Item)this);
        }
        this.attackSpeed = attackSpeed;
        this.attackDamage = 2.0f + toolMaterial.func_78000_c();
        this.chargeTime = chargeTime;
        if (this == InitItems.SLEDGEHAMMER_STARLIGHT) {
            this.func_77656_e(0);
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        LoreHelper.addInformationLore(tooltip, "Need a pickaxe, axe, shovel and sword in one single tool? This is your best bet.");
        LoreHelper.addControlsLore(tooltip, "Charge", LoreHelper.Type.USE, true);
        LoreHelper.addControlsLore(tooltip, "Excavates, Mines Veins & Fells Trees", LoreHelper.Type.RELEASE_USE);
    }

    public boolean func_77636_d(ItemStack stack) {
        return this == InitItems.SLEDGEHAMMER_STARLIGHT;
    }

    public float getAttackDamage() {
        return this.field_77862_b.func_78000_c();
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase e, int timeLeft) {
        EntityPlayer player = (EntityPlayer)e;
        EnumHand hand = EnumHand.OFF_HAND;
        if (ItemStack.func_77989_b((ItemStack)player.func_184614_ca(), (ItemStack)stack)) {
            hand = EnumHand.MAIN_HAND;
        }
        if (this.func_77626_a(stack) - timeLeft >= this.chargeTime) {
            player.func_184609_a(hand);
            Vec3d posVec = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
            Vec3d lookVec = player.func_70040_Z();
            RayTraceResult trace = worldIn.func_72933_a(posVec, posVec.func_178787_e(lookVec.func_186678_a(5.0)));
            if (trace != null) {
                BlockPos pos = trace.func_178782_a();
                Location location = new Location(worldIn, pos);
                Material mat = location.getBlockMaterial();
                if (location.getBlock() != null && this.field_77862_b.func_77996_d() >= location.getBlock().getHarvestLevel(location.getBlockState())) {
                    ItemStack blockStack;
                    float hardness = location.getBlockState().func_185887_b(worldIn, location.getBlockPos());
                    int harvestLevel = location.getBlock().getHarvestLevel(location.getBlockState());
                    if (hardness >= 0.0f && hardness <= 50.0f && this.field_77862_b.func_77996_d() >= harvestLevel && (blockStack = new ItemStack(location.getBlock())) != null && !blockStack.func_190926_b()) {
                        int[] ids;
                        player.func_184810_cG();
                        for (int id : ids = OreDictionary.getOreIDs((ItemStack)blockStack)) {
                            if (!OreDictionary.getOreName((int)id).contains("log") && !OreDictionary.getOreName((int)id).contains("ore")) continue;
                            this.veinMine(stack, player, location);
                            return;
                        }
                        this.excavateRock(worldIn, stack, player, location, trace.field_178784_b);
                    }
                }
            }
        }
    }

    private void excavateRock(World worldIn, ItemStack stack, EntityPlayer player, Location location, EnumFacing face) {
        int radius = EnchantmentHelper.func_77506_a((Enchantment)InitEnchantments.CRUSHING, (ItemStack)stack) + 1;
        ArrayList<Location> locations = WorldEditHelper.selectFlatCubeFromFace(location, face, radius);
        int damage = this.getDamage(stack);
        for (Location nextLocation : locations) {
            int maxDamage = this.getMaxDamage(stack);
            if (damage > maxDamage && maxDamage > 0) {
                return;
            }
            float hardness = nextLocation.getBlockState().func_185887_b(worldIn, nextLocation.getBlockPos());
            int harvestLevel = nextLocation.getBlock().getHarvestLevel(nextLocation.getBlockState());
            if (!(hardness >= 0.0f) || !(hardness <= 50.0f) || this.field_77862_b.func_77996_d() < harvestLevel) continue;
            nextLocation.breakBlock(player);
            stack.func_77972_a(1, (EntityLivingBase)player);
            ++damage;
        }
    }

    private void veinMine(ItemStack stack, EntityPlayer player, Location location) {
        IBlockState state = location.getBlockState();
        VeinScan scan = new VeinScan(location, state.func_177230_c());
        scan.startScan(64, true);
        int damage = this.getDamage(stack);
        for (Location nextLocation : scan.buffer) {
            int maxDamage = this.getMaxDamage(stack);
            if (damage > this.getMaxDamage(stack) && maxDamage > 0) {
                return;
            }
            nextLocation.breakBlock(player);
            stack.func_77972_a(1, (EntityLivingBase)player);
            ++damage;
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.clear();
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", this.attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", this.attackSpeed - 4.0, 0));
        }
        return multimap;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"pickaxe", (Object)"axe", (Object)"shovel");
    }

    public boolean func_150897_b(IBlockState block) {
        return EFFECTIVE_ON.contains(block.func_177230_c()) || super.func_150897_b(block);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return this.field_77864_a;
    }

    @Override
    public void registerModels() {
        CalemiUtils.proxy.registerItemRenderer((Item)this, 0, "inventory");
    }
}

