/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import calemiutils.config.CUConfig;
import calemiutils.item.base.ItemBase;
import calemiutils.util.Location;
import calemiutils.util.helper.InventoryHelper;
import calemiutils.util.helper.ItemHelper;
import calemiutils.util.helper.LoreHelper;
import calemiutils.util.helper.SoundHelper;
import calemiutils.util.helper.TorchHelper;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles", striprefs=true)
public class ItemTorchBelt
extends ItemBase
implements IBauble {
    public ItemTorchBelt() {
        super("torch_belt", 1);
        if (CUConfig.itemUtils.torchBelt) {
            this.addItem();
        }
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.BELT;
    }

    @Override
    public boolean func_77636_d(ItemStack stack) {
        return ItemHelper.getNBT(stack).func_74767_n("on");
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        LoreHelper.addInformationLore(tooltip, "Place this anywhere in your inventory. Automatically uses and places torches in dark areas.");
        LoreHelper.addControlsLore(tooltip, "Toggle ON/OFF", LoreHelper.Type.USE, true);
        tooltip.add("");
        tooltip.add("Status: " + ChatFormatting.AQUA + (ItemHelper.getNBT(stack).func_74767_n("on") ? "ON" : "OFF"));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        ItemHelper.getNBT(stack).func_74757_a("on", !ItemHelper.getNBT(stack).func_74767_n("on"));
        SoundHelper.playClick(worldIn, playerIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.tick(stack, worldIn, entityIn);
    }

    @Optional.Method(modid="baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        this.tick(stack, player.field_70170_p, (Entity)player);
    }

    private void tick(ItemStack stack, World worldIn, Entity entityIn) {
        if (entityIn instanceof EntityPlayer && ItemHelper.getNBT(stack).func_74767_n("on")) {
            EntityPlayer player = (EntityPlayer)entityIn;
            Location location = new Location(worldIn, (int)Math.floor(player.field_70165_t), (int)Math.floor(player.field_70163_u), (int)Math.floor(player.field_70161_v));
            if (location.getLightValue() <= 7 && (player.field_71075_bZ.field_75098_d || player.field_71071_by.func_70431_c(new ItemStack(Blocks.field_150478_aa))) && TorchHelper.canPlaceTorchAt(location)) {
                location.setBlock(Blocks.field_150478_aa);
                if (!player.field_71075_bZ.field_75098_d) {
                    InventoryHelper.consumeItem((IInventory)player.field_71071_by, 1, true, new ItemStack(Blocks.field_150478_aa));
                }
            }
        }
    }
}

