/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import calemiutils.CalemiUtils;
import calemiutils.config.CUConfig;
import calemiutils.init.InitItems;
import calemiutils.item.ItemCurrency;
import calemiutils.item.base.ItemBase;
import calemiutils.util.helper.InventoryHelper;
import calemiutils.util.helper.ItemHelper;
import calemiutils.util.helper.LoreHelper;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles", striprefs=true)
public class ItemWallet
extends ItemBase
implements IBauble {
    public ItemWallet() {
        super("wallet", 1);
        if (CUConfig.itemUtils.wallet) {
            this.addItem();
        }
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.TRINKET;
    }

    public static boolean isActive(ItemStack stack) {
        return ItemHelper.getNBT(stack).func_74767_n("active");
    }

    public static int getBalance(ItemStack stack) {
        return ItemHelper.getNBT(stack).func_74762_e("balance");
    }

    public void toggleSuck(ItemStack stack) {
        ItemHelper.getNBT(stack).func_74757_a("suck", !ItemHelper.getNBT(stack).func_74767_n("suck"));
    }

    public static void activate(ItemStack stack, boolean active) {
        ItemHelper.getNBT(stack).func_74757_a("active", active);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        LoreHelper.addDisabledLore(tooltip, CUConfig.wallet.walletCurrencyCapacity);
        LoreHelper.addInformationLore(tooltip, "Used to store currency in one place.");
        LoreHelper.addControlsLore(tooltip, "Open Inventory", LoreHelper.Type.USE, true);
        tooltip.add("");
        tooltip.add(ChatFormatting.AQUA + (ItemWallet.isActive(stack) ? "Active" : "Inactive"));
        tooltip.add("Suck: " + ChatFormatting.AQUA + (ItemHelper.getNBT(stack).func_74767_n("suck") ? "ON" : "OFF"));
        LoreHelper.addCurrencyLore(tooltip, ItemWallet.getBalance(stack), CUConfig.wallet.walletCurrencyCapacity);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!worldIn.field_72995_K && CUConfig.wallet.walletCurrencyCapacity > 0 && playerIn != null && !playerIn.func_184614_ca().func_190926_b()) {
            playerIn.openGui((Object)CalemiUtils.instance, 64, worldIn, (int)playerIn.field_70165_t, (int)playerIn.field_70163_u, (int)playerIn.field_70161_v);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.tick(stack, entityIn);
    }

    @Optional.Method(modid="baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        this.tick(stack, (Entity)player);
    }

    private void tick(ItemStack stack, Entity entityIn) {
        NBTTagCompound nbt = ItemHelper.getNBT(stack);
        if (entityIn.field_70170_p.func_72820_D() % 2L == 0L && entityIn instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityIn;
            if (ItemHelper.getNBT(stack).func_74767_n("suck")) {
                ItemStack[] coinStacks;
                for (ItemStack coinStack : coinStacks = new ItemStack[]{new ItemStack((Item)InitItems.COIN_PENNY), new ItemStack((Item)InitItems.COIN_NICKEL), new ItemStack((Item)InitItems.COIN_QUARTER), new ItemStack((Item)InitItems.COIN_DOLLAR)}) {
                    int value = ((ItemCurrency)coinStack.func_77973_b()).value;
                    if (InventoryHelper.countItems((IInventory)player.field_71071_by, false, false, coinStack) <= 0 || ItemWallet.getBalance(stack) + value > CUConfig.wallet.walletCurrencyCapacity) continue;
                    InventoryHelper.consumeItem((IInventory)player.field_71071_by, 1, false, coinStack);
                    nbt.func_74768_a("balance", ItemWallet.getBalance(stack) + value);
                    break;
                }
            }
        }
    }

    @Override
    public boolean func_77636_d(ItemStack stack) {
        return ItemHelper.getNBT(stack).func_74767_n("active");
    }
}

