/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.packet;

import calemiutils.init.InitItems;
import calemiutils.item.ItemInteractionInterfaceFilter;
import calemiutils.packet.ServerPacketHandler;
import calemiutils.tileentity.TileEntityInteractionInterface;
import calemiutils.util.Location;
import calemiutils.util.helper.ItemHelper;
import calemiutils.util.helper.PacketHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class InteractionUnitPacket
extends ServerPacketHandler {
    public InteractionUnitPacket() {
    }

    public InteractionUnitPacket(String text) {
        this.text = text;
    }

    public static class Handler
    implements IMessageHandler<InteractionUnitPacket, IMessage> {
        public IMessage onMessage(InteractionUnitPacket message, MessageContext ctx) {
            String[] data = message.text.split("%");
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            World world = player.field_70170_p;
            if (data[0].equalsIgnoreCase("interface-setfilter")) {
                Location location = PacketHelper.getLocation(world, data, 1);
                TileEntityInteractionInterface tileEntity = (TileEntityInteractionInterface)location.getTileEntity();
                if (tileEntity != null) {
                    String filterIconString = data[4];
                    String filterName = "";
                    if (data.length > 5) {
                        filterName = data[5];
                    }
                    ItemStack filterStack = new ItemStack(InitItems.INTERACTION_INTERFACE_FILTER);
                    ItemInteractionInterfaceFilter.setFilterIcon(filterStack, ItemHelper.getStackFromString(filterIconString));
                    ItemInteractionInterfaceFilter.setFilterName(filterStack, filterName);
                    tileEntity.tabIconStack = filterStack;
                }
            } else if (data[0].equalsIgnoreCase("interface-setblock")) {
                Location location = PacketHelper.getLocation(world, data, 1);
                TileEntityInteractionInterface tileEntity = (TileEntityInteractionInterface)location.getTileEntity();
                if (tileEntity != null) {
                    tileEntity.blockIconStack = ItemHelper.getStackFromString(data[4]);
                }
            } else if (data[0].equalsIgnoreCase("interface-setblockname")) {
                Location location = PacketHelper.getLocation(world, data, 1);
                TileEntityInteractionInterface tileEntity = (TileEntityInteractionInterface)location.getTileEntity();
                if (tileEntity != null) {
                    tileEntity.blockName = data.length > 4 ? data[4] : "";
                }
            } else if (data[0].equalsIgnoreCase("interface-clearfilter")) {
                Location location = PacketHelper.getLocation(world, data, 1);
                TileEntityInteractionInterface tileEntity = (TileEntityInteractionInterface)location.getTileEntity();
                if (tileEntity != null) {
                    tileEntity.tabIconStack = ItemStack.field_190927_a;
                }
            } else if (data[0].equalsIgnoreCase("interface-clearblock")) {
                Location location = PacketHelper.getLocation(world, data, 1);
                TileEntityInteractionInterface tileEntity = (TileEntityInteractionInterface)location.getTileEntity();
                if (tileEntity != null) {
                    tileEntity.blockIconStack = ItemStack.field_190927_a;
                }
            } else if (data[0].equalsIgnoreCase("terminal-interact")) {
                Location location = PacketHelper.getLocation(world, data, 1);
                boolean b = Boolean.parseBoolean(data[4]);
                player.func_70095_a(b);
                location.getBlock().func_180639_a(world, location.getBlockPos(), location.getBlockState(), (EntityPlayer)player, EnumHand.MAIN_HAND, EnumFacing.UP, 0.0f, 0.0f, 0.0f);
            }
            return null;
        }
    }
}

