/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.packet;

import calemiutils.config.MarketItemsFile;
import calemiutils.packet.ServerPacketHandler;
import calemiutils.tileentity.TileEntityBank;
import calemiutils.tileentity.TileEntityMarket;
import calemiutils.util.Location;
import calemiutils.util.helper.CurrencyHelper;
import calemiutils.util.helper.InventoryHelper;
import calemiutils.util.helper.ItemHelper;
import calemiutils.util.helper.PacketHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MarketPacket
extends ServerPacketHandler {
    public MarketPacket() {
    }

    public MarketPacket(String text) {
        this.text = text;
    }

    public static class Handler
    implements IMessageHandler<MarketPacket, IMessage> {
        public IMessage onMessage(MarketPacket message, MessageContext ctx) {
            String[] data = message.text.split("%");
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            World world = player.field_70170_p;
            if (data[0].equalsIgnoreCase("syncamount")) {
                Location location = PacketHelper.getLocation(world, data, 1);
                TileEntityMarket tileEntity = (TileEntityMarket)location.getTileEntity();
                tileEntity.purchaseAmount = Integer.parseInt(data[4]);
            } else if (data[0].equalsIgnoreCase("setbuymode")) {
                Location location = PacketHelper.getLocation(world, data, 1);
                TileEntityMarket tileEntity = (TileEntityMarket)location.getTileEntity();
                tileEntity.buyMode = Boolean.parseBoolean(data[4]);
            } else if (data[0].equalsIgnoreCase("setoffer")) {
                Location location = PacketHelper.getLocation(world, data, 1);
                TileEntityMarket tileEntity = (TileEntityMarket)location.getTileEntity();
                tileEntity.selectedOffer = Integer.parseInt(data[4]);
            } else if (data[0].equalsIgnoreCase("setautomode")) {
                Location location = PacketHelper.getLocation(world, data, 1);
                TileEntityMarket tileEntity = (TileEntityMarket)location.getTileEntity();
                tileEntity.automationMode = Boolean.parseBoolean(data[4]);
            } else if (data[0].equalsIgnoreCase("buy")) {
                String itemObj = data[1];
                int meta = Integer.parseInt(data[2]);
                int amount = Integer.parseInt(data[3]);
                int value = Integer.parseInt(data[4]);
                int purchaseAmount = Integer.parseInt(data[5]);
                ItemStack stack = CurrencyHelper.getCurrentWalletStack((EntityPlayer)player);
                if (data.length > 6) {
                    Location location = PacketHelper.getLocation(world, data, 6);
                    TileEntityBank teBank = (TileEntityBank)location.getTileEntity();
                    if (teBank.getStoredCurrency() >= value * purchaseAmount) {
                        teBank.addCurrency(-(value * purchaseAmount));
                    }
                } else {
                    ItemHelper.getNBT(stack).func_74768_a("balance", ItemHelper.getNBT(stack).func_74762_e("balance") - value * purchaseAmount);
                }
                ItemHelper.spawnItem(world, (Entity)player, new ItemStack(Item.func_111206_d((String)itemObj), amount * purchaseAmount, meta));
            } else if (data[0].equalsIgnoreCase("sell")) {
                String itemObj = data[1];
                int meta = Integer.parseInt(data[2]);
                int amount = Integer.parseInt(data[3]);
                int value = Integer.parseInt(data[4]);
                int purchaseAmount = Integer.parseInt(data[5]);
                ItemStack walletStack = CurrencyHelper.getCurrentWalletStack((EntityPlayer)player);
                if (data.length > 6) {
                    Location location = PacketHelper.getLocation(world, data, 6);
                    TileEntityBank teBank = (TileEntityBank)location.getTileEntity();
                    teBank.addCurrency(value * purchaseAmount);
                } else {
                    ItemHelper.getNBT(walletStack).func_74768_a("balance", ItemHelper.getNBT(walletStack).func_74762_e("balance") + value * purchaseAmount);
                }
                ItemStack[] stacks = MarketItemsFile.MarketItem.doesOreNameExist(itemObj) ? MarketItemsFile.MarketItem.getStacksFromOreDict(itemObj) : new ItemStack[]{MarketItemsFile.MarketItem.getStack(itemObj, amount, meta)};
                InventoryHelper.consumeItem((IInventory)player.field_71071_by, amount * purchaseAmount, false, stacks);
            }
            return null;
        }
    }
}

