/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.packet;

import calemiutils.CalemiUtils;
import calemiutils.item.ItemInteractionInterfaceFilter;
import calemiutils.item.ItemPencil;
import calemiutils.tileentity.TileEntityBank;
import calemiutils.tileentity.base.TileEntityBase;
import calemiutils.util.Location;
import calemiutils.util.helper.ItemHelper;
import calemiutils.util.helper.PacketHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ServerPacketHandler
implements IMessage {
    String text;

    public ServerPacketHandler() {
    }

    public ServerPacketHandler(String text) {
        this.text = text;
    }

    public void fromBytes(ByteBuf buf) {
        this.text = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.text);
    }

    public static class Handler
    implements IMessageHandler<ServerPacketHandler, IMessage> {
        public IMessage onMessage(ServerPacketHandler message, MessageContext ctx) {
            String[] data = message.text.split("%");
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            World world = player.field_70170_p;
            if (data[0].equalsIgnoreCase("te-enable")) {
                Location location = PacketHelper.getLocation(world, data, 1);
                boolean value = Boolean.valueOf(data[4]);
                TileEntity te = location.getTileEntity();
                if (te instanceof TileEntityBase) {
                    ((TileEntityBase)te).enable = value;
                    ((TileEntityBase)te).markForUpdate();
                }
            } else if (data[0].equalsIgnoreCase("gui-open")) {
                int id = Integer.parseInt(data[1]);
                player.openGui((Object)CalemiUtils.instance, id, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            } else if (data[0].equalsIgnoreCase("pencil-setcolor")) {
                int color = Integer.parseInt(data[1]);
                if (player.func_184614_ca().func_77973_b() instanceof ItemPencil) {
                    ItemPencil pencil = (ItemPencil)player.func_184614_ca().func_77973_b();
                    pencil.setColorByMeta(player.func_184614_ca(), color);
                }
            } else if (data[0].equalsIgnoreCase("bank-sync")) {
                Location location = PacketHelper.getLocation(world, data, 3);
                TileEntityBank tileEntity = (TileEntityBank)location.getTileEntity();
                if (tileEntity != null) {
                    NBTTagCompound nbt = ItemHelper.getNBT(tileEntity.func_70301_a(1));
                    tileEntity.storedCurrency = Integer.parseInt(data[1]);
                    nbt.func_74768_a("balance", Integer.parseInt(data[2]));
                }
            } else if (data[0].equalsIgnoreCase("iifilter-seticon")) {
                ItemStack stackToSet = ItemHelper.getStackFromString(data[1]);
                ItemStack stack = player.func_184614_ca();
                ItemInteractionInterfaceFilter.setFilterIcon(stack, stackToSet);
            } else if (data[0].equalsIgnoreCase("iifilter-setname")) {
                String name = "";
                String tooltip = "";
                if (data.length > 1) {
                    name = data[1];
                    if (data.length > 2) {
                        tooltip = data[2];
                    }
                }
                ItemStack stack = player.func_184614_ca();
                ItemInteractionInterfaceFilter.setFilterName(stack, name);
                ItemInteractionInterfaceFilter.setFilterTooltip(stack, tooltip);
            }
            return null;
        }
    }
}

