/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.tileentity;

import calemiutils.config.CUConfig;
import calemiutils.gui.GuiBank;
import calemiutils.inventory.ContainerBank;
import calemiutils.item.ItemCurrency;
import calemiutils.security.ISecurity;
import calemiutils.security.SecurityProfile;
import calemiutils.tileentity.base.ICurrencyNetworkBank;
import calemiutils.tileentity.base.ICurrencyNetworkUnit;
import calemiutils.tileentity.base.ITileEntityGuiHandler;
import calemiutils.tileentity.base.TileEntityInventoryBase;
import calemiutils.util.Location;
import calemiutils.util.VeinScan;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBank
extends TileEntityInventoryBase
implements ITileEntityGuiHandler,
ICurrencyNetworkBank,
ISecurity {
    public List<Location> connectedUnits = new ArrayList<Location>();
    public int storedCurrency = 0;
    private final SecurityProfile profile = new SecurityProfile();
    private VeinScan scan;

    public TileEntityBank() {
        this.setInputSlots(0, 1);
        this.setSideInputSlots(0, 1);
        this.setExtractSlots(0, 1);
    }

    public void func_73660_a() {
        if (this.getLocation() != null && this.scan == null) {
            this.scan = new VeinScan(this.getLocation());
        }
        if (this.scan != null && this.field_145850_b.func_72820_D() % 40L == 0L) {
            this.connectedUnits.clear();
            boolean foundAnotherBank = false;
            this.scan.reset();
            this.scan.startNetworkScan(this.getConnectedDirections());
            for (Location location : this.scan.buffer) {
                if (!location.equals(this.getLocation()) && location.getTileEntity() instanceof TileEntityBank) {
                    foundAnotherBank = true;
                }
                if (!(location.getTileEntity() instanceof ICurrencyNetworkUnit)) continue;
                ICurrencyNetworkUnit unit = (ICurrencyNetworkUnit)location.getTileEntity();
                this.connectedUnits.add(location);
                if (unit.getBankLocation() != null) continue;
                unit.setBankLocation(this.getLocation());
            }
            boolean bl = this.enable = !foundAnotherBank;
        }
        if (!this.field_145850_b.field_72995_K && this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b() instanceof ItemCurrency) {
            int amountToAdd = ((ItemCurrency)this.func_70301_a((int)0).func_77973_b()).value;
            int stackSize = 0;
            for (int i = 0; i < this.func_70301_a(0).func_190916_E(); ++i) {
                if (!this.canAddAmount(amountToAdd)) continue;
                ++stackSize;
                amountToAdd += ((ItemCurrency)this.func_70301_a((int)0).func_77973_b()).value;
            }
            if (stackSize != 0) {
                this.addCurrency(stackSize * ((ItemCurrency)this.func_70301_a((int)0).func_77973_b()).value);
                this.func_70298_a(0, stackSize);
            }
        }
    }

    private boolean canAddAmount(int amount) {
        int storedAmount = this.storedCurrency;
        return storedAmount + amount <= this.getMaxCurrency();
    }

    public void addCurrency(int amount) {
        this.markForUpdate();
        this.setCurrency(this.storedCurrency + amount);
    }

    @Override
    public Container getTileContainer(EntityPlayer player) {
        return new ContainerBank(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getTileGuiContainer(EntityPlayer player) {
        return new GuiBank(player, this);
    }

    public int func_70302_i_() {
        return 2;
    }

    @Override
    public int getStoredCurrency() {
        return this.storedCurrency;
    }

    @Override
    public void setCurrency(int amount) {
        int setAmount = amount;
        if (amount > this.getMaxCurrency()) {
            setAmount = this.getMaxCurrency();
        }
        this.storedCurrency = setAmount;
    }

    @Override
    public SecurityProfile getSecurityProfile() {
        return this.profile;
    }

    @Override
    public EnumFacing[] getConnectedDirections() {
        return EnumFacing.field_82609_l;
    }

    @Override
    public int getMaxCurrency() {
        return CUConfig.misc.bankCurrencyCapacity;
    }
}

