/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.tileentity;

import calemiutils.block.BlockMarker;
import calemiutils.blueprint.BlueprintBuild;
import calemiutils.blueprint.BlueprintPos;
import calemiutils.blueprint.BlueprintTemplate;
import calemiutils.config.CUConfig;
import calemiutils.gui.GuiBuildingUnitInventory;
import calemiutils.init.InitItems;
import calemiutils.inventory.ContainerBuildingUnit;
import calemiutils.item.ItemBuildingUnitTemplate;
import calemiutils.tileentity.base.ITileEntityGuiHandler;
import calemiutils.tileentity.base.TileEntityInventoryBase;
import calemiutils.util.BlueprintTemplates;
import calemiutils.util.helper.ItemHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBuildingUnit
extends TileEntityInventoryBase
implements ITileEntityGuiHandler {
    private static final float pixel = 0.0625f;
    private static final AxisAlignedBB FULL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public final List<BlueprintBuild> buildBlueprints;
    public int currentBuildBlueprint = 0;
    public int currentRotation = 0;
    public int horRange;
    public int verRange;

    public TileEntityBuildingUnit() {
        this.horRange = CUConfig.buildingUnit.buildingUnitHorizontalMaxRange;
        this.verRange = CUConfig.buildingUnit.buildingUnitVerticalMaxRange;
        this.buildBlueprints = new ArrayList<BlueprintBuild>();
    }

    public void func_73660_a() {
        this.currentBuildBlueprint = MathHelper.func_76125_a((int)this.currentBuildBlueprint, (int)0, (int)(this.buildBlueprints.size() - 1));
        if (this.field_145850_b.func_72820_D() % 20L == 0L) {
            this.readInvForBuildBlueprints();
            this.searchForMarkers();
        }
    }

    public void onLoad() {
        super.onLoad();
        this.buildBlueprints.add(new BlueprintBuild("None", new BlueprintTemplate(new ArrayList<BlueprintPos>())));
        this.buildBlueprints.add(new BlueprintBuild("9x9", new BlueprintTemplate(BlueprintTemplates.getNineByNine())));
    }

    public void addRotation() {
        ++this.currentRotation;
        this.currentRotation %= 4;
    }

    private BlueprintBuild getCurrentBlueprintBuild() {
        if (this.currentBuildBlueprint < this.buildBlueprints.size()) {
            return this.buildBlueprints.get(this.currentBuildBlueprint);
        }
        return this.buildBlueprints.get(0);
    }

    public List<BlueprintPos> getCurrentPositions() {
        return this.getCurrentBlueprintBuild().template.getPositions(this.currentRotation);
    }

    private void searchForMarkers() {
        int tempHorRange = CUConfig.buildingUnit.buildingUnitHorizontalMaxRange;
        int tempVerRange = CUConfig.buildingUnit.buildingUnitVerticalMaxRange;
        block0: for (EnumFacing dir : EnumFacing.field_176754_o) {
            for (int i = 0; i < CUConfig.buildingUnit.buildingUnitHorizontalMaxRange; ++i) {
                if (!(this.getLocation().translate(dir, i).getBlock() instanceof BlockMarker) || i >= tempHorRange) continue;
                tempHorRange = i;
                continue block0;
            }
        }
        for (int i = 0; i < CUConfig.buildingUnit.buildingUnitVerticalMaxRange; ++i) {
            if (!(this.getLocation().translate(EnumFacing.UP, i).getBlock() instanceof BlockMarker)) continue;
            tempVerRange = i;
            break;
        }
        this.horRange = tempHorRange;
        this.verRange = tempVerRange;
    }

    private void readInvForBuildBlueprints() {
        ArrayList<BlueprintBuild> list = new ArrayList<BlueprintBuild>();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (!stack.func_77942_o()) continue;
            NBTTagCompound nbt = ItemHelper.getNBT(stack);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBuildingUnitTemplate)) continue;
            list.add(new BlueprintBuild(nbt.func_74764_b("buildName") ? nbt.func_74779_i("buildName") : "Unnamed", BlueprintTemplate.readFromItem(stack)));
        }
        int size = this.buildBlueprints.size();
        if (list.size() + 2 != size) {
            if (size > 2) {
                this.buildBlueprints.subList(2, size).clear();
            }
            this.buildBlueprints.addAll(list);
            this.markForUpdate();
        }
    }

    public void readBlueprintsInRange(EntityPlayer player, String name) {
        BlueprintTemplate template = BlueprintTemplate.scan(this);
        if (template.positions.size() > 0) {
            if (template.positions.size() < CUConfig.buildingUnit.buildingUnitBlockSize) {
                ItemStack stack = new ItemStack(InitItems.BUILDING_UNIT_TEMPLATE);
                EntityItem entity = ItemHelper.spawnItem(this.func_145831_w(), this.getLocation().translate(EnumFacing.UP, 1), stack);
                entity.func_92058_a(template.writeToItem(stack));
                if (!name.isEmpty()) {
                    ItemHelper.getNBT(stack).func_74778_a("buildName", name);
                }
            } else {
                this.getUnitName(player).printMessage(TextFormatting.RED, "There are too many Blueprints in range! (" + (template.positions.size() - CUConfig.buildingUnit.buildingUnitBlockSize + 1) + " Blueprint(s) over). Try reducing the size with Markers!");
            }
        } else {
            this.getUnitName(player).printMessage(TextFormatting.RED, "There are no Blueprints in range!");
        }
    }

    public void placeBlueprints() {
        this.getCurrentBlueprintBuild().template.construct(this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return FULL_AABB.func_186662_g((double)CUConfig.buildingUnit.buildingUnitRenderBoxSize).func_186670_a(this.func_174877_v());
    }

    @Override
    public Container getTileContainer(EntityPlayer player) {
        return new ContainerBuildingUnit(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getTileGuiContainer(EntityPlayer player) {
        return new GuiBuildingUnitInventory(player, this);
    }

    public int func_70302_i_() {
        return 27;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.currentBuildBlueprint = nbt.func_74762_e("buildBlueprint");
        this.currentRotation = nbt.func_74762_e("currentRotation");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("buildBlueprint", this.currentBuildBlueprint);
        nbt.func_74768_a("currentRotation", this.currentRotation);
        return nbt;
    }
}

