/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.tileentity;

import calemiutils.item.ItemInteractionInterfaceFilter;
import calemiutils.security.ISecurity;
import calemiutils.security.SecurityProfile;
import calemiutils.tileentity.TileEntityInteractionInterface;
import calemiutils.tileentity.base.INetwork;
import calemiutils.tileentity.base.TileEntityBase;
import calemiutils.util.Location;
import calemiutils.util.VeinScan;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class TileEntityInteractionTerminal
extends TileEntityBase
implements INetwork,
ISecurity {
    private final SecurityProfile profile = new SecurityProfile();
    private VeinScan scan;
    public final List<Location> blocksToInteract = new ArrayList<Location>();

    public void func_73660_a() {
        if (this.getLocation() != null && this.scan == null) {
            this.scan = new VeinScan(this.getLocation());
        }
    }

    public void huntForInterfaces() {
        this.blocksToInteract.clear();
        this.scan.reset();
        this.scan.startNetworkScan(this.getConnectedDirections());
        for (Location location : this.scan.buffer) {
            if (!(location.getTileEntity() instanceof TileEntityInteractionInterface)) continue;
            TileEntityInteractionInterface tileInterface = (TileEntityInteractionInterface)location.getTileEntity();
            Location locationBlock = new Location(tileInterface.getLocation(), EnumFacing.UP);
            if (!tileInterface.getSecurityProfile().isOwner(this.profile.getOwnerName()) || locationBlock.isAirBlock()) continue;
            this.blocksToInteract.add(locationBlock);
        }
    }

    public ItemStack getFilterStack(Location location) {
        TileEntityInteractionInterface tileInterface = (TileEntityInteractionInterface)location.getTileEntity();
        ItemStack stack = tileInterface.tabIconStack;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemInteractionInterfaceFilter) {
            return stack;
        }
        return null;
    }

    private ItemInteractionInterfaceFilter getFilter(Location location) {
        TileEntityInteractionInterface tileInterface = (TileEntityInteractionInterface)location.getTileEntity();
        ItemStack stack = tileInterface.tabIconStack;
        if (this.getFilterStack(location) != null) {
            return (ItemInteractionInterfaceFilter)stack.func_77973_b();
        }
        return null;
    }

    private ItemStack getFilterTabIcon(Location location) {
        if (this.getFilter(location) != null) {
            return ItemInteractionInterfaceFilter.getFilterIcon(this.getFilterStack(location));
        }
        return null;
    }

    private String getFilterName(Location location) {
        if (this.getFilter(location) != null) {
            return ItemInteractionInterfaceFilter.getFilterName(this.getFilterStack(location));
        }
        return "";
    }

    public boolean isValidFilter(Location location) {
        ItemStack filterIcon = this.getFilterTabIcon(location);
        if (location != null && this.getFilter(location) != null && filterIcon != null) {
            return !filterIcon.func_190926_b() && !this.getFilterName(location).isEmpty();
        }
        return false;
    }

    @Override
    public SecurityProfile getSecurityProfile() {
        return this.profile;
    }

    @Override
    public EnumFacing[] getConnectedDirections() {
        return new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST};
    }
}

