/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.tileentity;

import calemiutils.config.MarketItemsFile;
import calemiutils.security.ISecurity;
import calemiutils.security.SecurityProfile;
import calemiutils.tileentity.TileEntityBank;
import calemiutils.tileentity.base.ICurrencyNetworkUnit;
import calemiutils.tileentity.base.TileEntityBase;
import calemiutils.util.Location;
import calemiutils.util.helper.CurrencyHelper;
import calemiutils.util.helper.InventoryHelper;
import calemiutils.util.helper.NetworkHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class TileEntityMarket
extends TileEntityBase
implements ISecurity,
ICurrencyNetworkUnit {
    private final SecurityProfile profile = new SecurityProfile();
    public final List<MarketItemsFile.MarketItem> marketItemList = new ArrayList<MarketItemsFile.MarketItem>();
    public boolean buyMode = true;
    public boolean automationMode = false;
    public int selectedOffer;
    public int purchaseAmount = 1;
    private Location bankLocation;
    public boolean dirtyFlag = true;

    private void registerMarketItems() {
        this.marketItemList.clear();
        this.marketItemList.addAll(MarketItemsFile.registeredBlocks.values());
        this.marketItemList.sort(Comparator.comparingInt(o -> o.index));
        this.dirtyFlag = false;
        for (int i = 0; i < this.marketItemList.size(); ++i) {
            if (!this.marketItemList.get((int)i).isBuy) continue;
            this.selectedOffer = i;
            break;
        }
        this.markForUpdate();
    }

    public MarketItemsFile.MarketItem getSelectedOffer() {
        if (this.selectedOffer >= this.marketItemList.size() || this.selectedOffer < 0) {
            return null;
        }
        return this.marketItemList.get(this.selectedOffer);
    }

    @Override
    public Location getBankLocation() {
        return this.bankLocation;
    }

    @Override
    public void setBankLocation(Location location) {
        this.bankLocation = location;
    }

    public TileEntityBank getBank() {
        TileEntityBank bank = NetworkHelper.getConnectedBank(this.getLocation(), this.bankLocation);
        if (bank == null) {
            this.bankLocation = null;
        }
        return bank;
    }

    private IInventory getConnectedInventory() {
        Location location = this.getLocation().translate(EnumFacing.UP, 1);
        if (location.getTileEntity() != null && !(location.getTileEntity() instanceof TileEntityBank) && location.getTileEntity() instanceof IInventory) {
            return (IInventory)location.getTileEntity();
        }
        return null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.dirtyFlag) {
            this.registerMarketItems();
        }
        MarketItemsFile.MarketItem marketItem = this.getSelectedOffer();
        TileEntityBank bank = this.getBank();
        IInventory inv = this.getConnectedInventory();
        if (this.field_145850_b.func_72820_D() % 10L == 0L && this.automationMode && marketItem != null && bank != null && inv != null) {
            boolean buyMode = marketItem.isBuy;
            if (buyMode) {
                if (bank.getStoredCurrency() >= marketItem.value && InventoryHelper.canInsertItem(marketItem.getStack(), inv)) {
                    InventoryHelper.insertItem(marketItem.getStack(), inv);
                    bank.addCurrency(-marketItem.value);
                }
            } else if (CurrencyHelper.canFitAddedCurrencyToNetwork(bank, marketItem.value) && InventoryHelper.countItems(inv, false, false, marketItem.getStack()) >= marketItem.amount) {
                InventoryHelper.consumeItem(inv, marketItem.amount, false, marketItem.getStack());
                bank.addCurrency(marketItem.value);
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound root) {
        this.buyMode = root.func_74767_n("buyMode");
        this.automationMode = root.func_74767_n("autoMode");
        this.selectedOffer = root.func_74762_e("selectedOffer");
        this.purchaseAmount = root.func_74762_e("purchaseAmount");
        this.marketItemList.clear();
        if (root.func_74764_b("MarketItems")) {
            NBTTagCompound marketParent = root.func_74775_l("MarketItems");
            for (int i = 0; i < marketParent.func_186856_d(); ++i) {
                NBTTagCompound itemTag = marketParent.func_74775_l("Item" + i);
                this.marketItemList.add(MarketItemsFile.MarketItem.readFromNBT(itemTag));
            }
        }
        super.func_145839_a(root);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound root) {
        NBTTagCompound parent = new NBTTagCompound();
        for (int i = 0; i < this.marketItemList.size(); ++i) {
            MarketItemsFile.MarketItem marketItem = this.marketItemList.get(i);
            NBTTagCompound marketTag = marketItem.writeToNBT();
            parent.func_74782_a("Item" + i, (NBTBase)marketTag);
        }
        root.func_74782_a("MarketItems", (NBTBase)parent);
        root.func_74757_a("buyMode", this.buyMode);
        root.func_74757_a("autoMode", this.automationMode);
        root.func_74768_a("selectedOffer", this.selectedOffer);
        root.func_74768_a("purchaseAmount", this.purchaseAmount);
        return super.func_189515_b(root);
    }

    @Override
    public EnumFacing[] getConnectedDirections() {
        return EnumFacing.field_82609_l;
    }

    @Override
    public SecurityProfile getSecurityProfile() {
        return this.profile;
    }
}

