/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.tileentity;

import calemiutils.config.CUConfig;
import calemiutils.config.MiningUnitCostsFile;
import calemiutils.gui.GuiDiggingUnit;
import calemiutils.inventory.ContainerDiggingUnit;
import calemiutils.tileentity.base.TileEntityDiggingUnitBase;
import calemiutils.util.Location;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityMiningUnit
extends TileEntityDiggingUnitBase {
    @Override
    public Container getTileContainer(EntityPlayer player) {
        return new ContainerDiggingUnit(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getTileGuiContainer(EntityPlayer player) {
        return new GuiDiggingUnit(player, this, "Mining Unit");
    }

    @Override
    public List<Location> getLocationsToMine() {
        ArrayList<Location> oreList = new ArrayList<Location>();
        block0: for (Location location : this.getLocationsWithinRange()) {
            ItemStack stack = new ItemStack(location.getBlock(), 1, location.getBlockMeta());
            for (MiningUnitCostsFile.BlockInformation information : MiningUnitCostsFile.registeredBlocks.values()) {
                for (ItemStack oreStack : OreDictionary.getOres((String)information.oreName)) {
                    if (!ItemStack.func_179545_c((ItemStack)oreStack, (ItemStack)stack)) continue;
                    oreList.add(location);
                    continue block0;
                }
                for (Item oreBlock : MiningUnitCostsFile.oreBlocks) {
                    if (oreBlock != stack.func_77973_b()) continue;
                    oreList.add(location);
                    continue block0;
                }
            }
        }
        return oreList;
    }

    @Override
    public int getCurrentOreCost() {
        MiningUnitCostsFile.BlockInformation information = MiningUnitCostsFile.BlockInformation.getFromStack(this.getCurrentLocationStack());
        if (information != null) {
            return this.scaleCost(information.cost);
        }
        return 0;
    }

    @Override
    public int getScaledSpeedMin() {
        return 3;
    }

    @Override
    public int getScaledSpeedMax() {
        return 15;
    }

    @Override
    public int getScaledRangeMax() {
        return CUConfig.misc.miningUnitMaxRange;
    }
}

