/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.tileentity;

import calemiutils.config.CUConfig;
import calemiutils.gui.GuiDiggingUnit;
import calemiutils.inventory.ContainerDiggingUnit;
import calemiutils.tileentity.base.TileEntityDiggingUnitBase;
import calemiutils.util.Location;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityQuarryUnit
extends TileEntityDiggingUnitBase {
    @Override
    public Container getTileContainer(EntityPlayer player) {
        return new ContainerDiggingUnit(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getTileGuiContainer(EntityPlayer player) {
        return new GuiDiggingUnit(player, this, "Quarry Unit");
    }

    @Override
    public List<Location> getLocationsToMine() {
        ArrayList<Location> blockList = new ArrayList<Location>();
        for (Location location : this.getLocationsWithinRange()) {
            ItemStack stack = new ItemStack(location.getBlock(), 1, location.getBlockMeta());
            if ((location.getBlockState() == Blocks.field_150348_b.func_176223_P() || location.getBlock() != Blocks.field_150348_b) && location.getBlock() != Blocks.field_150351_n && location.getBlock() != Blocks.field_150435_aG && location.getBlock() != Blocks.field_150405_ch && location.getBlock() != Blocks.field_150406_ce) continue;
            ArrayList<String> names = new ArrayList<String>();
            for (String name : OreDictionary.getOreNames()) {
                if (!name.startsWith("ore")) continue;
                names.add(name);
            }
            boolean pass = true;
            for (String name : names) {
                for (ItemStack oreStack : OreDictionary.getOres((String)name)) {
                    if (!ItemStack.func_179545_c((ItemStack)oreStack, (ItemStack)stack)) continue;
                    pass = false;
                }
            }
            if (!pass) continue;
            blockList.add(location);
        }
        return blockList;
    }

    @Override
    public int getCurrentOreCost() {
        return CUConfig.misc.quarryUnitCost;
    }

    @Override
    public int getScaledSpeedMin() {
        return 3;
    }

    @Override
    public int getScaledSpeedMax() {
        return 15;
    }

    @Override
    public int getScaledRangeMax() {
        return CUConfig.misc.miningUnitMaxRange;
    }
}

