/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.tileentity;

import calemiutils.config.CUConfig;
import calemiutils.gui.GuiTorchPlacer;
import calemiutils.inventory.ContainerTorchPlacer;
import calemiutils.tileentity.base.TileEntityUpgradable;
import calemiutils.util.Location;
import calemiutils.util.helper.InventoryHelper;
import calemiutils.util.helper.MathHelper;
import calemiutils.util.helper.TorchHelper;
import calemiutils.util.helper.WorldEditHelper;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTorchPlacer
extends TileEntityUpgradable {
    private static final BlockTorch TORCH = (BlockTorch)Blocks.field_150478_aa;
    private static final ItemStack TORCH_STACK = new ItemStack((Block)TORCH);

    public TileEntityTorchPlacer() {
        this.setInputSlots(MathHelper.getCountingArray(0, 28));
        this.setSideInputSlots(MathHelper.getCountingArray(0, 28));
        this.setExtractSlots(MathHelper.getCountingArray(2, 28));
        this.enable = false;
    }

    public void func_73660_a() {
        if (this.enable && this.hasTorches()) {
            Location darkSpot = this.findDarkSpot();
            if (darkSpot == null && this.currentRange < this.getScaledRange()) {
                ++this.currentRange;
            } else if (darkSpot != null) {
                this.tickProgress();
                if (this.isDoneAndReset()) {
                    darkSpot.setBlock((Block)TORCH);
                    InventoryHelper.consumeItem((IInventory)this, 1, true, TORCH_STACK);
                }
            }
        } else {
            this.currentRange = 0;
            this.currentProgress = 0;
        }
    }

    private Location findDarkSpot() {
        ArrayList<Location> locations = WorldEditHelper.selectWallsFromRadius(this.getLocation(), this.currentRange, 8);
        ArrayList test = new ArrayList();
        for (Location nextLocation : locations) {
            if (!TorchHelper.canPlaceTorchAt(nextLocation)) continue;
            return nextLocation;
        }
        return null;
    }

    private boolean hasTorches() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null || this.func_70301_a(i).func_77973_b() != Item.func_150898_a((Block)TORCH)) continue;
            return true;
        }
        return false;
    }

    public int func_70302_i_() {
        return 29;
    }

    @Override
    public Container getTileContainer(EntityPlayer player) {
        return new ContainerTorchPlacer(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getTileGuiContainer(EntityPlayer player) {
        return new GuiTorchPlacer(player, this);
    }

    @Override
    public int getSpeedSlot() {
        return 0;
    }

    @Override
    public int getRangeSlot() {
        return 1;
    }

    @Override
    public int getMaxProgress() {
        return 100;
    }

    @Override
    public int getScaledSpeedMin() {
        return 3;
    }

    @Override
    public int getScaledSpeedMax() {
        return 15;
    }

    @Override
    public int getScaledRangeMin() {
        return 10;
    }

    @Override
    public int getScaledRangeMax() {
        return CUConfig.misc.torchPlacerMaxRange;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        return super.func_189515_b(nbt);
    }
}

