/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.tileentity;

import calemiutils.gui.GuiTradingPost;
import calemiutils.inventory.ContainerTradingPost;
import calemiutils.security.ISecurity;
import calemiutils.security.SecurityProfile;
import calemiutils.tileentity.TileEntityBank;
import calemiutils.tileentity.base.ICurrencyNetworkUnit;
import calemiutils.tileentity.base.ITileEntityGuiHandler;
import calemiutils.tileentity.base.TileEntityInventoryBase;
import calemiutils.util.Location;
import calemiutils.util.UnitChatMessage;
import calemiutils.util.helper.MathHelper;
import calemiutils.util.helper.NBTHelper;
import calemiutils.util.helper.NetworkHelper;
import calemiutils.util.helper.StringHelper;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTradingPost
extends TileEntityInventoryBase
implements ITileEntityGuiHandler,
ICurrencyNetworkUnit,
ISecurity {
    private final SecurityProfile profile = new SecurityProfile();
    private Location bankLocation;
    public int amountForSale;
    public int salePrice;
    public boolean hasValidTradeOffer;
    private ItemStack stackForSale = ItemStack.field_190927_a;
    public boolean adminMode = false;
    public boolean buyMode = false;

    public TileEntityTradingPost() {
        this.setInputSlots(MathHelper.getCountingArray(0, 26));
        this.setSideInputSlots(MathHelper.getCountingArray(0, 26));
        this.amountForSale = 1;
        this.salePrice = 0;
        this.hasValidTradeOffer = false;
    }

    @Override
    public Location getBankLocation() {
        return this.bankLocation;
    }

    @Override
    public void setBankLocation(Location location) {
        this.bankLocation = location;
    }

    public TileEntityBank getBank() {
        TileEntityBank bank = NetworkHelper.getConnectedBank(this.getLocation(), this.bankLocation);
        if (bank == null) {
            this.bankLocation = null;
        }
        return bank;
    }

    public int getStoredCurrencyInBank() {
        if (this.getBank() != null) {
            return this.getBank().getStoredCurrency();
        }
        return 0;
    }

    public void addStoredCurrencyInBank(int amount) {
        if (this.getBank() != null) {
            this.getBank().setCurrency(this.getBank().getStoredCurrency() + amount);
        }
    }

    public void decrStoredCurrencyInBank(int amount) {
        if (this.getBank() != null) {
            this.getBank().addCurrency(-amount);
        }
    }

    @Override
    public UnitChatMessage getUnitName(EntityPlayer player) {
        if (this.adminMode) {
            return new UnitChatMessage("Admin Post", player);
        }
        return new UnitChatMessage(this.getSecurityProfile().getOwnerName() + "'s Trading Post", player);
    }

    public void func_73660_a() {
        this.hasValidTradeOffer = this.getStackForSale() != null && !this.getStackForSale().func_190926_b() && this.amountForSale >= 1;
    }

    public int getStock() {
        if (this.getStackForSale() != null) {
            int count = 0;
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                if (this.func_70301_a(i) == null || !this.func_70301_a(i).func_77969_a(this.getStackForSale())) continue;
                if (this.getStackForSale().func_77942_o()) {
                    if (!this.func_70301_a(i).func_77942_o() || !this.func_70301_a(i).func_77978_p().equals((Object)this.getStackForSale().func_77978_p())) continue;
                    count += this.func_70301_a(i).func_190916_E();
                    continue;
                }
                count += this.func_70301_a(i).func_190916_E();
            }
            return count;
        }
        return 0;
    }

    public ItemStack getStackForSale() {
        return this.stackForSale;
    }

    public void setStackForSale(ItemStack stack) {
        this.stackForSale = stack;
    }

    @Override
    public Container getTileContainer(EntityPlayer player) {
        return new ContainerTradingPost(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getTileGuiContainer(EntityPlayer player) {
        return new GuiTradingPost(player, this);
    }

    public int func_70302_i_() {
        return 27;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.amountForSale = nbt.func_74762_e("amount");
        this.salePrice = nbt.func_74762_e("price");
        this.stackForSale = NBTHelper.loadItem(nbt, 0);
        this.adminMode = nbt.func_74767_n("adminMode");
        this.buyMode = nbt.func_74767_n("buyMode");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("amount", this.amountForSale);
        nbt.func_74768_a("price", this.salePrice);
        NBTHelper.saveItem(nbt, this.stackForSale, 0);
        nbt.func_74757_a("adminMode", this.adminMode);
        nbt.func_74757_a("buyMode", this.buyMode);
        return nbt;
    }

    @Override
    public SecurityProfile getSecurityProfile() {
        return this.profile;
    }

    @Override
    public EnumFacing[] getConnectedDirections() {
        return new EnumFacing[]{EnumFacing.DOWN};
    }

    public ITextComponent func_145748_c_() {
        if (this.hasValidTradeOffer) {
            return new TextComponentString((this.buyMode ? "Buying " : "Selling ") + this.amountForSale + "x " + this.getStackForSale().func_82833_r() + " for " + StringHelper.printCurrency(this.salePrice));
        }
        return null;
    }
}

