/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.tileentity.base;

import calemiutils.tileentity.TileEntityBank;
import calemiutils.tileentity.base.ICurrencyNetworkUnit;
import calemiutils.tileentity.base.TileEntityUpgradable;
import calemiutils.util.Location;
import calemiutils.util.helper.InventoryHelper;
import calemiutils.util.helper.MathHelper;
import calemiutils.util.helper.NetworkHelper;
import calemiutils.util.helper.WorldEditHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public abstract class TileEntityDiggingUnitBase
extends TileEntityUpgradable
implements ICurrencyNetworkUnit {
    public List<Location> locationsToMine = new ArrayList<Location>();
    private Location currentLocationToMine = null;
    private boolean shouldCheckForLocations;
    private Location bankLocation;

    protected TileEntityDiggingUnitBase() {
        this.setInputSlots(MathHelper.getCountingArray(0, 28));
        this.setSideInputSlots(MathHelper.getCountingArray(0, 28));
        this.setExtractSlots(MathHelper.getCountingArray(2, 28));
        this.enable = false;
        this.shouldCheckForLocations = true;
    }

    protected abstract List<Location> getLocationsToMine();

    public abstract int getCurrentOreCost();

    @Override
    public Location getBankLocation() {
        return this.bankLocation;
    }

    @Override
    public void setBankLocation(Location location) {
        this.bankLocation = location;
    }

    public TileEntityBank getBank() {
        TileEntityBank bank = NetworkHelper.getConnectedBank(this.getLocation(), this.bankLocation);
        if (bank == null) {
            this.bankLocation = null;
        }
        return bank;
    }

    private int getStoredCurrencyInBank() {
        if (this.getBank() != null) {
            return this.getBank().getStoredCurrency();
        }
        return 0;
    }

    private void decrStoredCurrencyInBank(int amount) {
        if (this.getBank() != null) {
            this.getBank().addCurrency(-amount);
        }
    }

    public void func_73660_a() {
        if (this.enable) {
            if (this.shouldCheckForLocations) {
                this.locationsToMine = this.getLocationsToMine();
                this.shouldCheckForLocations = false;
            }
            if (this.getBank() != null) {
                if (!this.locationsToMine.isEmpty()) {
                    if (this.currentLocationToMine == null) {
                        this.findCurrentLocationToMine();
                    } else {
                        ItemStack stack = new ItemStack(this.currentLocationToMine.getBlock(), 1, this.currentLocationToMine.getBlockMeta());
                        if (InventoryHelper.canInsertItem(stack, (IInventory)this) && this.getStoredCurrencyInBank() >= this.getCurrentOreCost()) {
                            this.tickProgress();
                            if (this.isDoneAndReset()) {
                                this.decrStoredCurrencyInBank(this.getCurrentOreCost());
                                if (!this.field_145850_b.field_72995_K) {
                                    InventoryHelper.insertItem(stack, (IInventory)this, 2);
                                }
                                this.currentLocationToMine.setBlock(this.getBlockToReplace());
                                this.locationsToMine.remove(this.currentLocationToMine);
                                this.currentLocationToMine = null;
                            }
                        } else {
                            this.currentProgress = 0;
                        }
                    }
                } else if (this.currentRange < this.getScaledRange()) {
                    ++this.currentRange;
                    this.shouldCheckForLocations = true;
                }
            }
        } else {
            this.currentLocationToMine = null;
            this.currentProgress = 0;
            this.currentRange = 0;
            this.shouldCheckForLocations = true;
        }
    }

    private Block getBlockToReplace() {
        int dim = this.field_145850_b.field_73011_w.func_186058_p().func_186068_a();
        if (dim == -1) {
            return Blocks.field_150424_aL;
        }
        if (dim == 1) {
            return Blocks.field_150377_bs;
        }
        return Blocks.field_150348_b;
    }

    public ItemStack getCurrentLocationStack() {
        if (this.currentLocationToMine != null) {
            return new ItemStack(this.currentLocationToMine.getBlock(), 1, this.currentLocationToMine.getBlockMeta());
        }
        return null;
    }

    private void findCurrentLocationToMine() {
        if (this.locationsToMine.size() > 0) {
            Location location = this.locationsToMine.get(0);
            if (!location.isAirBlock() && location.getBlockState() != this.getBlockToReplace().func_176223_P()) {
                this.currentLocationToMine = location;
            } else {
                this.locationsToMine.remove(location);
                this.findCurrentLocationToMine();
            }
        } else {
            this.currentLocationToMine = null;
        }
    }

    protected ArrayList<Location> getLocationsWithinRange() {
        return WorldEditHelper.selectWallsFromRadius(this.getLocation(), this.currentRange, -this.getLocation().y + 1, 0);
    }

    @Override
    public EnumFacing[] getConnectedDirections() {
        return EnumFacing.field_82609_l;
    }

    @Override
    public int getMaxProgress() {
        return 100;
    }

    public int func_70302_i_() {
        return 29;
    }

    @Override
    public int getSpeedSlot() {
        return 0;
    }

    @Override
    public int getRangeSlot() {
        return 1;
    }

    @Override
    public int getScaledRangeMin() {
        return 10;
    }
}

