/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.tileentity.base;

import calemiutils.config.CUConfig;
import calemiutils.tileentity.base.IProgress;
import calemiutils.tileentity.base.IRange;
import calemiutils.tileentity.base.TileEntityInventoryBase;
import calemiutils.util.helper.MathHelper;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileEntityUpgradable
extends TileEntityInventoryBase
implements IProgress,
IRange {
    protected int currentProgress;
    public int currentRange;

    protected abstract int getSpeedSlot();

    protected abstract int getRangeSlot();

    protected abstract int getScaledSpeedMin();

    protected abstract int getScaledSpeedMax();

    protected abstract int getScaledRangeMin();

    protected abstract int getScaledRangeMax();

    private int getScaledSpeed() {
        return this.getScaledSlot(this.getSpeedSlot(), this.getScaledSpeedMin(), this.getScaledSpeedMax());
    }

    public int getScaledRange() {
        return this.getScaledSlot(this.getRangeSlot(), this.getScaledRangeMin(), this.getScaledRangeMax());
    }

    private int getScaledSlot(int slot, int min, int max) {
        int difference = max - min;
        return min + MathHelper.scaleInt(this.func_70301_a(slot).func_190916_E(), CUConfig.misc.upgradeStackSize, difference);
    }

    protected int scaleCost(int cost) {
        return cost + (int)((double)cost * CUConfig.misc.speedUpgradeCostMultiplier * (double)this.func_70301_a(this.getSpeedSlot()).func_190916_E());
    }

    protected void tickProgress() {
        this.currentProgress += this.getScaledSpeed();
    }

    protected boolean isDoneAndReset() {
        if (this.currentProgress >= this.getMaxProgress()) {
            this.currentProgress = 0;
            return true;
        }
        return false;
    }

    @Override
    public int getCurrentProgress() {
        return this.currentProgress;
    }

    @Override
    public int getCurrentRange() {
        return this.currentRange;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.currentProgress = nbt.func_74762_e("currentProgress");
        this.currentRange = nbt.func_74762_e("currentRange");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("currentProgress", this.currentProgress);
        nbt.func_74768_a("currentRange", this.currentRange);
        return nbt;
    }
}

