/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.util;

import calemiutils.util.helper.ItemHelper;
import calemiutils.util.helper.SoundHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Location {
    public static final Location INVALID = new Location(null, 0, -100, 0);
    public final World world;
    public int x;
    public int y;
    public int z;
    private BlockPos blockPos;

    public Location(World world, int x, int y, int z) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.blockPos = new BlockPos(x, y, z);
    }

    public Location(World world, BlockPos pos) {
        this(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public Location(TileEntity tileEntity) {
        this(tileEntity.func_145831_w(), tileEntity.func_174877_v().func_177958_n(), tileEntity.func_174877_v().func_177956_o(), tileEntity.func_174877_v().func_177952_p());
    }

    public Location(Entity entity) {
        this(entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v);
    }

    public Location(Location location, EnumFacing dir, int distance) {
        this.world = location.world;
        this.x = location.x + dir.func_82601_c() * distance;
        this.y = location.y + dir.func_96559_d() * distance;
        this.z = location.z + dir.func_82599_e() * distance;
        this.blockPos = new BlockPos(this.x, this.y, this.z);
    }

    public Location(Location location, EnumFacing dir) {
        this(location, dir, 1);
    }

    public Location translate(EnumFacing dir, int distance) {
        this.x += dir.func_82601_c() * distance;
        this.y += dir.func_96559_d() * distance;
        this.z += dir.func_82599_e() * distance;
        this.blockPos = new BlockPos(this.x, this.y, this.z);
        return this;
    }

    public Location translate(Location location) {
        this.x += location.x;
        this.y += location.y;
        this.z += location.z;
        this.blockPos = new BlockPos(this.x, this.y, this.z);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Location) {
            Location newLoc = (Location)obj;
            return this.world == newLoc.world && this.x == newLoc.x && this.y == newLoc.y && this.z == newLoc.z;
        }
        return super.equals(obj);
    }

    public double getDistance(Location location) {
        int dx = this.x - location.x;
        int dy = this.y - location.y;
        int dz = this.z - location.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public IBlockState getBlockState() {
        if (this.getBlockPos() == null || this.equals(INVALID)) {
            return null;
        }
        return this.world.func_180495_p(this.getBlockPos());
    }

    public Block getBlock() {
        if (this.getBlockState() == null) {
            return null;
        }
        return this.getBlockState().func_177230_c();
    }

    public void setBlock(Block block) {
        this.world.func_175656_a(this.getBlockPos(), block.func_176223_P());
    }

    public void setBlock(IBlockState state) {
        this.world.func_175656_a(this.getBlockPos(), state.func_177230_c().func_176223_P());
        this.world.func_175656_a(this.getBlockPos(), state);
    }

    public void breakBlock(EntityPlayer player) {
        SoundHelper.playBlockPlaceSound(this.world, player, this.getBlockState(), this);
        if (!this.world.field_72995_K && !player.field_71075_bZ.field_75098_d) {
            ItemHelper.spawnItems(this.world, this, this.getDrops());
        }
        if (!this.world.field_72995_K) {
            this.setBlockToAir();
        }
    }

    public int getBlockMeta() {
        if (this.getBlock() == null) {
            return 0;
        }
        return this.getBlock().func_176201_c(this.getBlockState());
    }

    public Material getBlockMaterial() {
        return this.getBlock().func_149688_o(this.getBlockState());
    }

    public List<ItemStack> getDrops() {
        return this.getBlock().getDrops((IBlockAccess)this.world, this.getBlockPos(), this.getBlockState(), 0);
    }

    public TileEntity getTileEntity() {
        return this.world.func_175625_s(this.getBlockPos());
    }

    public IInventory getIInventory() {
        if (this.getTileEntity() != null && this.getTileEntity() instanceof IInventory) {
            return (IInventory)this.getTileEntity();
        }
        return null;
    }

    public int getLightValue() {
        return this.world.func_175721_c(this.getBlockPos(), false);
    }

    public void setBlock(Block block, EntityPlayer placer) {
        this.setBlock(block);
        block.func_180633_a(this.world, this.getBlockPos(), block.func_176223_P(), (EntityLivingBase)placer, new ItemStack(block));
    }

    public void setBlock(IBlockState state, EntityPlayer placer) {
        this.world.func_180501_a(this.getBlockPos(), state, 2);
        state.func_177230_c().func_180633_a(this.world, this.getBlockPos(), state, (EntityLivingBase)placer, new ItemStack(state.func_177230_c()));
    }

    public void setBlockToAir() {
        this.world.func_175698_g(this.getBlockPos());
    }

    public boolean isAirBlock() {
        return this.getBlock() == Blocks.field_150350_a;
    }

    public boolean isBlockValidForPlacing(Block block) {
        return block.func_176196_c(this.world, this.getBlockPos()) || this.isAirBlock();
    }

    private boolean isZero() {
        return this.x == 0 && this.y == 0 && this.z == 0;
    }

    public static Location readFromNBT(World world, NBTTagCompound nbt) {
        int z;
        int y;
        int x = nbt.func_74762_e("locX");
        Location loc = new Location(world, x, y = nbt.func_74762_e("locY"), z = nbt.func_74762_e("locZ"));
        if (!loc.isZero()) {
            return loc;
        }
        return INVALID;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("locX", this.z);
        nbt.func_74768_a("locY", this.y);
        nbt.func_74768_a("locZ", this.z);
    }

    public boolean isEmpty() {
        return this.x == 0 && this.y == 0 && this.z == 0;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }
}

