/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.util;

import calemiutils.config.CUConfig;
import calemiutils.tileentity.base.INetwork;
import calemiutils.util.Location;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class VeinScan {
    public final ArrayList<Location> buffer = new ArrayList();
    private final Location location;
    private Block block;
    private IBlockState state;

    public VeinScan(Location location, Block block) {
        this.location = location;
        this.block = block;
    }

    public VeinScan(Location location, IBlockState state) {
        this.location = location;
        this.state = state;
    }

    public VeinScan(Location location) {
        this.location = location;
    }

    public void startScan() {
        this.reset();
        this.scan(this.location, 0, false);
    }

    public void startScan(int customMaxSize, boolean useRadiusToBranch) {
        this.reset();
        this.scan(this.location, customMaxSize, useRadiusToBranch);
    }

    public void startNetworkScan(EnumFacing[] directions) {
        for (EnumFacing dir : directions) {
            this.scanNetwork(new Location(this.location, dir), dir);
        }
    }

    public void reset() {
        this.buffer.clear();
    }

    private void scan(Location location, int customMazSize, boolean useRadiusToBranch) {
        block10: {
            if (customMazSize == 0) {
                customMazSize = CUConfig.blockScans.veinScanMaxSize;
            }
            if (this.buffer.size() >= customMazSize) {
                return;
            }
            if (this.buffer.contains(location) || location.getBlock() == null) break block10;
            if (this.state != null && location.getBlockState() != this.state) {
                return;
            }
            if (this.block != null && location.getBlock() != this.block) {
                return;
            }
            this.buffer.add(location);
            if (useRadiusToBranch) {
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            Location nextLocation = new Location(location.world, location.x + x, location.y + y, location.z + z);
                            this.scan(nextLocation, customMazSize, useRadiusToBranch);
                        }
                    }
                }
            } else {
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    this.scan(new Location(location, dir), customMazSize, useRadiusToBranch);
                }
            }
        }
    }

    private void scanNetwork(Location location, EnumFacing oldDir) {
        if (this.buffer.size() >= CUConfig.blockScans.veinScanMaxSize) {
            return;
        }
        TileEntity tileEntity = location.getTileEntity();
        if (tileEntity != null && tileEntity instanceof INetwork) {
            INetwork network = (INetwork)tileEntity;
            for (EnumFacing dir : network.getConnectedDirections()) {
                if (oldDir != dir.func_176734_d() || this.contains(location)) continue;
                this.buffer.add(location);
                for (EnumFacing searchDir : network.getConnectedDirections()) {
                    this.scanNetwork(new Location(location, searchDir), searchDir);
                }
            }
        }
    }

    private boolean contains(Location location) {
        for (Location nextLocation : this.buffer) {
            if (!nextLocation.equals(location)) continue;
            return true;
        }
        return false;
    }
}

