/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.util.helper;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import calemiutils.config.CUConfig;
import calemiutils.item.ItemWallet;
import calemiutils.tileentity.base.ICurrencyNetworkBank;
import calemiutils.util.helper.ItemHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;

public class CurrencyHelper {
    public static ItemStack getCurrentWalletStack(EntityPlayer player) {
        return CurrencyHelper.getCurrentWalletStack(player, true);
    }

    public static ItemStack getCurrentWalletStack(EntityPlayer player, boolean checkForActivity) {
        if (checkForActivity) {
            CurrencyHelper.checkForActiveWallets(player);
        }
        if (player.func_184614_ca().func_77973_b() instanceof ItemWallet && (!checkForActivity || ItemWallet.isActive(player.func_184614_ca()))) {
            return player.func_184614_ca();
        }
        if (player.func_184592_cb().func_77973_b() instanceof ItemWallet && (!checkForActivity || ItemWallet.isActive(player.func_184592_cb()))) {
            return player.func_184592_cb();
        }
        if (Loader.isModLoaded((String)"baubles")) {
            IBaublesItemHandler container = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < container.getSlots(); ++i) {
                ItemStack stack = container.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof ItemWallet) || checkForActivity && !ItemWallet.isActive(stack)) continue;
                return stack;
            }
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof ItemWallet) || checkForActivity && !ItemWallet.isActive(stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static List<ItemStack> checkForActiveWallets(EntityPlayer player) {
        ArrayList<ItemStack> walletList = new ArrayList<ItemStack>();
        if (Loader.isModLoaded((String)"baubles")) {
            IBaublesItemHandler container = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < container.getSlots(); ++i) {
                ItemStack stack = container.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof ItemWallet) || !ItemWallet.isActive(stack)) continue;
                walletList.add(stack);
            }
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof ItemWallet) || !ItemWallet.isActive(stack)) continue;
            walletList.add(stack);
        }
        if (walletList.size() > 1) {
            for (ItemStack stack : walletList) {
                ItemHelper.getNBT(stack).func_74757_a("active", false);
                System.out.println("Set Inactive");
            }
        }
        return walletList;
    }

    private static void addWallet(List<ItemStack> walletList, ItemStack stackToAdd) {
        for (ItemStack stackInList : walletList) {
            if (ItemStack.func_77989_b((ItemStack)stackToAdd, (ItemStack)stackToAdd)) continue;
            walletList.add(stackToAdd);
        }
    }

    public static boolean canFitAddedCurrencyToNetwork(ICurrencyNetworkBank network, int addAmount) {
        return network.getStoredCurrency() + addAmount <= network.getMaxCurrency();
    }

    public static boolean canFitAddedCurrencyToWallet(ItemStack walletStack, int addAmount) {
        if (!walletStack.func_190926_b() && walletStack.func_77973_b() instanceof ItemWallet) {
            return ItemWallet.getBalance(walletStack) + addAmount <= CUConfig.wallet.walletCurrencyCapacity;
        }
        return false;
    }
}

