/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.util.helper;

import calemiutils.item.ItemBuildersKit;
import calemiutils.tileentity.base.TileEntityInventoryBase;
import calemiutils.util.Location;
import calemiutils.util.helper.ItemHelper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class InventoryHelper {
    public static boolean canInsertItem(ItemStack stack, IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            boolean equalAndNotFull;
            ItemStack slot = inventory.func_70301_a(i);
            boolean bl = equalAndNotFull = ItemStack.func_179545_c((ItemStack)slot, (ItemStack)stack) && slot.func_190916_E() + stack.func_190916_E() < inventory.func_70297_j_();
            if (!inventory.func_94041_b(i, stack) || !slot.func_190926_b() && !equalAndNotFull) continue;
            return true;
        }
        return false;
    }

    public static void insertItem(ItemStack stack, IInventory inventory, int slotOffset) {
        for (int i = slotOffset; i < inventory.func_70302_i_(); ++i) {
            ItemStack slot = inventory.func_70301_a(i);
            if (ItemStack.func_179545_c((ItemStack)slot, (ItemStack)stack) && slot.func_190916_E() + stack.func_190916_E() <= inventory.func_70297_j_()) {
                inventory.func_70299_a(i, new ItemStack(stack.func_77973_b(), slot.func_190916_E() + stack.func_190916_E(), stack.func_77952_i()));
                return;
            }
            if (!slot.func_190926_b()) continue;
            inventory.func_70299_a(i, stack);
            return;
        }
    }

    public static void insertItem(ItemStack stack, IInventory inventory) {
        InventoryHelper.insertItem(stack, inventory, 0);
    }

    public static boolean insertHeldItemIntoSlot(EntityPlayer player, EnumHand hand, Location location, IInventory inventory, int slot, boolean removeStack) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity te = location.getTileEntity();
        if (inventory.func_70302_i_() > slot && !stack.func_190926_b() && inventory.func_70301_a(slot).func_190926_b()) {
            inventory.func_70299_a(slot, stack.func_77946_l());
            if (removeStack) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
            if (te instanceof TileEntityInventoryBase) {
                TileEntityInventoryBase teBase = (TileEntityInventoryBase)te;
                teBase.markForUpdate();
            }
            return true;
        }
        return false;
    }

    public static void breakInventory(World world, IInventory inventory, Location location) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            EntityItem dropEntity = ItemHelper.spawnItem(world, location, stack);
            if (!stack.func_77942_o()) continue;
            dropEntity.func_92059_d().func_77982_d(stack.func_77978_p());
        }
    }

    public static void consumeItem(IInventory inventory, int amount, boolean suckFromBuildersKit, ItemStack ... itemStack) {
        InventoryHelper.consumeItem(0, inventory, amount, suckFromBuildersKit, false, itemStack);
    }

    public static void consumeItem(int slotOffset, IInventory inventory, int amount, boolean suckFromBuildersKit, boolean useNBT, ItemStack ... itemStacks) {
        int amountLeft = amount;
        if (InventoryHelper.countItems(inventory, suckFromBuildersKit, useNBT, itemStacks) >= amount) {
            for (int i = slotOffset; i < inventory.func_70302_i_() && amountLeft > 0; ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                if (suckFromBuildersKit && stack.func_77973_b() instanceof ItemBuildersKit) {
                    ItemBuildersKit buildersKit = (ItemBuildersKit)stack.func_77973_b();
                    ItemStack[] itemStackArray = itemStacks;
                    int n = itemStackArray.length;
                    for (int j = 0; j < n; ++j) {
                        ItemStack itemStack = itemStackArray[j];
                        if (buildersKit.getBlockType(stack) == null || !buildersKit.getBlockType(stack).func_77969_a(itemStack) || useNBT && itemStack.func_77942_o() && (!stack.func_77942_o() || !stack.func_77978_p().equals((Object)itemStack.func_77978_p()))) continue;
                        int stackAmount = ItemBuildersKit.getAmountOfBlocks(stack);
                        if (amountLeft >= stackAmount) {
                            amountLeft -= stackAmount;
                            ItemBuildersKit.setAmountOfBlocks(stack, 0);
                            continue;
                        }
                        ItemBuildersKit.setAmountOfBlocks(stack, stackAmount - amountLeft);
                        amountLeft -= stackAmount;
                    }
                }
                for (ItemStack itemStack : itemStacks) {
                    if (!stack.func_77969_a(itemStack) || useNBT && itemStack.func_77942_o() && (!stack.func_77942_o() || !stack.func_77978_p().equals((Object)itemStack.func_77978_p()))) continue;
                    if (amountLeft >= stack.func_190916_E()) {
                        amountLeft -= stack.func_190916_E();
                        inventory.func_70299_a(i, ItemStack.field_190927_a);
                        continue;
                    }
                    ItemStack copy = stack.func_77946_l();
                    inventory.func_70298_a(i, amountLeft);
                    amountLeft -= copy.func_190916_E();
                }
            }
        }
    }

    public static int countItems(IInventory inventory, boolean countFromBuildersKit, boolean useNBT, ItemStack ... itemStacks) {
        int count = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (countFromBuildersKit && stack.func_77973_b() instanceof ItemBuildersKit) {
                ItemBuildersKit buildersKit = (ItemBuildersKit)stack.func_77973_b();
                ItemStack[] itemStackArray = itemStacks;
                int n = itemStackArray.length;
                for (int j = 0; j < n; ++j) {
                    ItemStack itemStack = itemStackArray[j];
                    if (buildersKit.getBlockType(stack) == null || !buildersKit.getBlockType(stack).func_77969_a(itemStack)) continue;
                    if (useNBT && itemStack.func_77942_o()) {
                        if (!stack.func_77942_o() || !stack.func_77978_p().equals((Object)itemStack.func_77978_p())) continue;
                        count += ItemBuildersKit.getAmountOfBlocks(stack);
                        continue;
                    }
                    count += ItemBuildersKit.getAmountOfBlocks(stack);
                }
            }
            for (ItemStack itemStack : itemStacks) {
                if (!stack.func_77969_a(itemStack)) continue;
                if (useNBT && itemStack.func_77942_o() && stack.func_77942_o() && stack.func_77978_p().equals((Object)itemStack.func_77978_p())) {
                    count += stack.func_190916_E();
                }
                count += stack.func_190916_E();
            }
        }
        return count;
    }
}

