/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.util.helper;

import calemiutils.util.Location;
import calemiutils.util.helper.StringHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemHelper {
    private static final Random rand = new Random();

    public static NBTTagCompound getNBT(ItemStack is) {
        if (is.func_77978_p() == null) {
            is.func_77982_d(new NBTTagCompound());
        }
        return is.func_77978_p();
    }

    public static String getStringFromStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return "null";
        }
        return Item.func_150891_b((Item)stack.func_77973_b()) + "&" + stack.func_190916_E() + "&" + stack.func_77960_j();
    }

    public static String getNBTFromStack(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().toString();
        }
        return "";
    }

    public static ItemStack getStackFromString(String string) {
        String[] data;
        if (!string.equalsIgnoreCase("null") && (data = string.split("&")).length == 3) {
            int itemId = Integer.parseInt(data[0]);
            int stackSize = Integer.parseInt(data[1]);
            int meta = Integer.parseInt(data[2]);
            return new ItemStack(Item.func_150899_d((int)itemId), stackSize, meta);
        }
        return ItemStack.field_190927_a;
    }

    public static void attachNBTFromString(ItemStack stack, String nbtString) {
        try {
            stack.func_77982_d(JsonToNBT.func_180713_a((String)nbtString));
        }
        catch (NBTException e) {
            e.printStackTrace();
        }
    }

    public static String countByStacks(int count) {
        int remainder = count % 64;
        return StringHelper.printCommas(count) + " blocks" + (count > 64 ? " (" + (int)Math.floor(count / 64) + " stack(s)" + (remainder > 0 ? " + " + remainder + " blocks)" : ")") : "");
    }

    public static EntityItem spawnItem(World world, Location location, ItemStack is) {
        return ItemHelper.spawnItem(world, (float)location.x + 0.5f, (float)location.y + 0.5f, (float)location.z + 0.5f, is);
    }

    public static EntityItem spawnItem(World world, Entity entity, ItemStack is) {
        return ItemHelper.spawnItem(world, (float)entity.field_70165_t, (float)entity.field_70163_u, (float)entity.field_70161_v, is);
    }

    private static EntityItem spawnItem(World world, float x, float y, float z, ItemStack is) {
        EntityItem item = new EntityItem(world, (double)x, (double)y, (double)z, is);
        item.func_174868_q();
        item.field_70159_w = -0.05f + rand.nextFloat() * 0.1f;
        item.field_70181_x = -0.05f + rand.nextFloat() * 0.1f;
        item.field_70179_y = -0.05f + rand.nextFloat() * 0.1f;
        world.func_72838_d((Entity)item);
        return item;
    }

    public static void spawnItems(World world, Location location, List<ItemStack> is) {
        ItemHelper.spawnItems(world, (float)location.x + 0.5f, (float)location.y + 0.5f, (float)location.z + 0.5f, is);
    }

    private static void spawnItems(World world, float x, float y, float z, List<ItemStack> stacks) {
        for (ItemStack is : stacks) {
            EntityItem item = new EntityItem(world, (double)x, (double)y, (double)z, is);
            item.func_174868_q();
            item.field_70159_w = -0.05f + rand.nextFloat() * 0.1f;
            item.field_70181_x = -0.05f + rand.nextFloat() * 0.1f;
            item.field_70179_y = -0.05f + rand.nextFloat() * 0.1f;
            world.func_72838_d((Entity)item);
        }
    }
}

